<?php
include_once "../connect.php";
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Credentials: true");
header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
$database_connect = new database_connect();


// $query = "SELECT * FROM slider WHERE status=1 "; 

if (isset($_GET['language'])) {
    $language = $database_connect->sanitize($_GET['language']);
} else {
    $language = 'english';
}

if ($language !== 'english') {
    $query = "
        SELECT 
            slider.id, 
            slider.image, 
            slider.link, 
            slider.date_created, 
            slider_translation.title AS title, 
            slider_translation.description AS description, 
            slider_translation.button AS button 
        FROM 
            slider
        JOIN 
            slider_translation ON slider.id = slider_translation.slider_id
        JOIN 
            languages ON slider_translation.language_id = languages.id
        WHERE 
            slider.status = 1 AND languages.name = '$language'
    ";
} else {
    // Query for the 'slider' table ONLY
    $query = "SELECT * FROM slider WHERE status = 1 ";
}

if (isset($_GET['id'])) {
    $id = $_GET['id'];
    $query .= " AND id = $id"; 
}
if (isset($_GET['title'])) {
    $title = $_GET['title'];
    $query .= " AND title LIKE '%$title%'";
}
if (isset($_GET['description'])) {
    $description = $_GET['description'];
    $query .= " AND description LIKE '%$description%'";
}
if (isset($_GET['status'])) {
    $status = $_GET['status'];
    $query .= " AND status = $status";
}
$result = $database_connect->get_results($query);
$response = array();

if ($result) {
    $objects = array(); 

    foreach ($result as $row) {
        $object = array(); 
        $object['id'] = $row['id'];
        $object['title'] = $row['title'];
        $object['description'] = $row['description'];
        $object['image'] = $path_img.$row['image'];
        $object['button'] = $row['button'];
        $object['link'] = $row['link'];
        $object['status'] = $row['status'];
        $object['date_created'] = $row['date_created'];
        array_push($objects, $object);
    }

    $response['success'] = true;
    $response['objects'] = $objects;

} else {
    $response['success'] = false;
    $response['message'] = 'No sliders found';
    $response['objects'] = array();
}
echo json_encode($response);
?>
