/*-------------------------------------------
            Dictionary Script
-------------------------------------------*/

$(document).ready(function () {
    applyDictionary();
});

function applyDictionary() {
    const dictionary = JSON.parse(sessionStorage.getItem("dictionary"));
    // console.log("dictionary: " + JSON.stringify(dictionary));

    if (dictionary) {
        $('[name]').each(function () {
            const name = $(this).attr('name');
            if (dictionary[name]) {
                if ($(this).is('input, textarea')) {
                    // Update placeholder for input and textarea
                    $(this).attr('placeholder', dictionary[name]);
                } else {
                    // Update the text for other elements
                    $(this).text(dictionary[name]);
                }
            }
        });
    } else {
        console.error("Dictionary not found in sessionStorage.");
    }
}


/*-------------------------------------------
            END Dictionary Script
-------------------------------------------*/