<!-- ======= Breadcrumb Section ======= -->
<section class="bg-bread">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1 class="" name="cart">Cart</h1>
                <h4 class=""><span name="home">Home</span> / <span name="cart">Cart</span></h4>
            </div>
        </div>
    </div>
</section>
<!-- ====== End Breadcrumb Section ====== -->

<section>
    <div class="container">

        <div class="row">

            <div class="col-xl-9 col-lg-8 col-md-12">
                <table class="table table-borderless table-striped" id="cartTable">
                    <tr>
                        <th class="rounded-start" name="item">Item</th>
                        <th name="item_name">Item Name</th>
                        <th name="unit_color">Color</th>
                        <th name="unit_size">Size</th>
                        <th name="unit_price">Unit Price</th>
                        <th name="qty">Qty</th>
                        <th name="price">Price</th>
                        <th class="rounded-end"></th>
                    </tr>

                    <!--<pre>-->
                    <?php
                    // var_dump($_SESSION["cart"]);
                    ?>
                    <!--</pre>-->

                    <?php
$total = 0;

if (isset($_SESSION["cart"]) && count($_SESSION["cart"]) > 0) {
    foreach ($_SESSION["cart"] as $index => $cart_item) {
        $productId = $cart_item["id"];
        $sizeId = $cart_item["size_id"];
        $colorId = $cart_item["color_id"];
        $quantity = $cart_item["quantity"];

        if ($language !== 'english') {
            $query_item = "
                SELECT 
                    i.id, 
                    i.price, 
                    i.image, 
                    i.discount, 
                    i.quantity AS stock_quantity, 
                    item_translation.name AS name, 
                    item_translation.description AS description 
                FROM 
                    `item` i 
                JOIN 
                    `item_translation` ON i.id = item_translation.item_id
                JOIN 
                    `languages` ON item_translation.language_id = languages.id
                WHERE 
                    i.status = 1 
                    AND languages.name = '$language' 
                    AND i.id = $productId";
        } else {
            $query_item = "
                SELECT 
                    i.id, 
                    i.name, 
                    i.image, 
                    i.description, 
                    i.price, 
                    i.discount, 
                    i.quantity AS stock_quantity, 
                    i.category_id 
                FROM 
                    `item` i 
                WHERE 
                    i.status = 1 
                    AND i.id = $productId";
        }

        $query_item_size = "
            SELECT 
                size.id, 
                size.name, 
                item_size.price, 
                item_size.discount, 
                item_size.out_of_stock 
            FROM 
                item_size 
            JOIN 
                size ON item_size.size_id = size.id 
            WHERE 
                item_size.status = 1 
                AND item_size.item_id = $productId
                AND size.id = $sizeId";

        $query_item_color = "
            SELECT 
                color.id, 
                color.name, 
                item_color.out_of_stock 
            FROM 
                item_color 
            JOIN 
                color ON item_color.color_id = color.id 
            WHERE 
                item_color.status = 1 
                AND item_color.item_id = $productId
                AND color.id = $colorId";

        $item_result = $conn->query($query_item);
        $size_result = $conn->query($query_item_size);
        $color_result = $conn->query($query_item_color);

        if ($item_result && $size_result && $color_result) {
            $item = $item_result->fetch_assoc();
            $size = $size_result->fetch_assoc();
            $color = $color_result->fetch_assoc();

            // Step 1: Get base price from size or item
            $unit_price = $size['price'] ?? $item['price'];

            // Step 2: Determine discount
            $discount = 0; // Default discount

            // Priority 1: Size table discount (if not null or 0)
            if (!empty($size['discount']) && $size['discount'] > 0) {
                $discount = $size['discount'];
            }
            // Priority 2: Item table discount (if size discount is null or 0, and item discount > 0)
            elseif (!empty($item['discount']) && $item['discount'] > 0) {
                $discount = $item['discount'];
            }

            // Step 3: Calculate the discounted price and overall price
            $discounted_price = $unit_price - ($unit_price * ($discount / 100));
            $overall_price = $discounted_price * $quantity;

            $total += $overall_price;

            // Render table row per item
            ?>
            <tr id="cart-item-<?php echo $productId; ?>-<?php echo $sizeId; ?>-<?php echo $colorId; ?>">
                <td class="rounded-start">
                    <img id="img-<?php echo $productId; ?>-<?php echo $sizeId; ?>-<?php echo $colorId; ?>" 
                         class="cart-item-img" 
                         src="<?php echo $path_img . $item['image']; ?>" 
                         alt="<?php echo $item['name']; ?>" />
                </td>
                <td>
                    <a href="index.php?p=product&id=<?php echo $productId; ?>" id="name-<?php echo $productId; ?>-<?php echo $sizeId; ?>-<?php echo $colorId; ?>">
                        <?php echo $item['name']; ?>
                    </a>
                </td>
                <td id="unit-color-<?php echo $productId; ?>-<?php echo $sizeId; ?>-<?php echo $colorId; ?>">
                    <?php echo !empty($color['name']) ? $color['name'] : 'N/A'; ?>
                </td>
                <td id="unit-size-<?php echo $productId; ?>-<?php echo $sizeId; ?>-<?php echo $colorId; ?>">
                    <?php echo !empty($size['name']) ? $size['name'] : 'N/A'; ?>
                </td>
                <td id="unit-price-<?php echo $productId; ?>-<?php echo $sizeId; ?>-<?php echo $colorId; ?>">
                    <?php echo $currency . " " . number_format($discounted_price, 2); ?>
                </td>
                <td>
                    x<?php echo $quantity; ?>
                </td>
                <td id="price-<?php echo $productId; ?>-<?php echo $sizeId; ?>-<?php echo $colorId; ?>">
                    <?php echo $currency . " " . number_format($overall_price, 2); ?>
                </td>
                <td class="d-flex justify-content-center align-items-center rounded-end cart-svg-height">
                    <button type="button" class="removeBtn" onclick="update_cart('remove', <?php echo $productId; ?>, null, <?php echo $sizeId; ?>, <?php echo $colorId; ?>)">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 352 512" class="">
                            <path d="M242.7 256l100.1-100.1c12.3-12.3 12.3-32.2 0-44.5l-22.2-22.2c-12.3-12.3-32.2-12.3-44.5 0L176 189.3 75.9 89.2c-12.3-12.3-32.2-12.3-44.5 0L9.2 111.5c-12.3 12.3-12.3 32.2 0 44.5L109.3 256 9.2 356.1c-12.3 12.3-12.3 32.2 0 44.5l22.2 22.2c12.3 12.3 32.2 12.3 44.5 0L176 322.7l100.1 100.1c12.3 12.3 32.2 12.3 44.5 0l22.2-22.2c12.3-12.3 12.3-32.2 0-44.5L242.7 256z" />
                        </svg>
                    </button>
                </td>
            </tr>
            <?php
        } else {
            echo "<tr><td colspan='8'>Error fetching item details</td></tr>";
        }
    }
} else {
    echo "<tr><td colspan='8' name='no_items'>No items in the cart</td></tr>";
}
?>

                </table>

            </div>

            <div class="col-xl-3 col-lg-4 col-md-12">
                <table class="table table-borderless table-striped" id="">
                    <tr>
                        <th class="rounded-start" name="total">Total</th>
                        <th class="rounded-end text-end" id="cartTotal"><?php echo $currency; ?> <?php echo number_format($total, 2);; ?></th>
                    </tr>
                </table>
                <div>
                    <?php
                    if (isset($_SESSION['client_id'])) {
                    ?>
                        <div class="d-flex justify-content-between mb-3">
                            <a href="index.php?p=checkout" class="shopBtn" name="checkout">Checkout</a>
                            <button class="shopBtn" onclick="update_cart('empty','')" name="empty_cart">Empty Cart</button>
                        </div>
                    <?php
                    } else {
                    ?>
                        <div class="d-flex justify-content-between mb-3">
                            <a href="index.php?p=checkout" class="shopBtn" name="checkout_guest">Checkout as Guest</a>
                            <a href="index.php?p=login" class="shopBtn" name="login">Login</a>
                        </div>
                        <button class="shopBtn" onclick="update_cart('empty','')" name="empty_cart">Empty Cart</button>
                    <?php
                    }
                    ?>
                </div>
            </div>

        </div>

    </div>
</section>

<script>
    $(document).ready(function() {
        // loadCartItems();
    });

    function loadCartItems() {
        const cart = <?php echo json_encode($_SESSION["cart"]); ?>;
        const path_api = "<?php echo $path_api; ?>";

        // Check if cart is not empty before proceeding
        if (cart && cart.length > 0) {
            let total = 0;

            // Iterate through each cart item
            $.each(cart, function(index, cartItem) {
                const productId = cartItem.id; // Extract product ID from the cart item
                const sizeId = cartItem.size_id; // Extract size ID
                const colorId = cartItem.color_id; // Extract color ID
                const quantity = cartItem.quantity; // Extract quantity

                const apiUrl = `${path_api}item.php?id=${productId}&size_id=${sizeId}&color_id=${colorId}&language=` + language;

                console.log('apiUrl: ' + apiUrl);

                $.ajax({
                    url: apiUrl,
                    method: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        if (data.success && data.objects.length > 0) {
                            const item = data.objects[0];

                            // Find size and color details
                            const selectedSize = item.size.find(s => s.id == sizeId) || null;
                            const selectedColor = item.color.find(c => c.id == colorId) || null;

                            // Calculate price and discount
                            let itemPrice, discount;
                            if (selectedSize) {
                                itemPrice = selectedSize.price;
                                discount = selectedSize.discount && selectedSize.discount > 0 ? selectedSize.discount : item.discount || 0;
                            } else {
                                itemPrice = item.price;
                                discount = item.discount || 0;
                            }

                            const finalPrice = parseFloat(itemPrice) - (parseFloat(itemPrice) * discount / 100);
                            const itemTotal = finalPrice * parseInt(quantity);
                            total += itemTotal;

                            // Update HTML elements
                            $(`#img-${productId}-${sizeId}-${colorId}`).attr("src", item.image[0]);
                            $(`#name-${productId}-${sizeId}-${colorId}`).text(item.name);
                            $(`#unit-color-${productId}-${sizeId}-${colorId}`).text(selectedColor ? selectedColor.name : "N/A");
                            $(`#unit-size-${productId}-${sizeId}-${colorId}`).text(selectedSize ? selectedSize.name : "N/A");
                            $(`#unit-price-${productId}-${sizeId}-${colorId}`).text(`<?php echo $currency; ?> ${finalPrice.toFixed(2)}`);
                            $(`#price-${productId}-${sizeId}-${colorId}`).text(`<?php echo $currency; ?> ${itemTotal.toFixed(2)}`);

                            // Update the total price in the cart
                            $(`#cartTotal`).text(`<?php echo $currency; ?> ${total.toFixed(2)}`);
                        } else {
                            console.error('Item details not found for product ID:', productId);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('Error fetching item details:', error);
                    }
                });
            });
        } else {
            console.log('Cart is empty, no items to load.');
        }
    }
</script>