<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $item_id = intval($_POST['item_id']);
    $quantity = intval($_POST['quantity']);
    $size_id = intval($_POST['size_id']);
    $color_id = intval($_POST['color_id']);
    $type = $_POST['type']; // 'add', 'remove', or 'empty'

    // Check if cart exists in session
    if (!isset($_SESSION['cart'])) {
        $_SESSION['cart'] = array();
    }

    switch ($type) {
        case 'add':
            // Optional parameters for add
            // $item_name = isset($_POST['item_name']) ? htmlspecialchars($_POST['item_name']) : '';
            // $item_price = isset($_POST['item_price']) ? floatval($_POST['item_price']) : 0.0;
            
            // If the item exists, update the quantity
            if (isset($_SESSION['cart'][$item_id])) {
                $_SESSION['cart'][$item_id]['quantity'] += $quantity;
            } else {
                $_SESSION['cart'][$item_id] = array(
                    'id' => $item_id,
                    'size_id' => $size_id,
                    'color_id' => $color_id,
                    // 'name' => $item_name,
                    // 'price' => $item_price,
                    'quantity' => $quantity
                );
            }
            // echo "Item added to cart";
            break;

        case 'remove':
            // If the item exists, remove it from the cart
            if (isset($_SESSION['cart'][$item_id])) {
                unset($_SESSION['cart'][$item_id]);
                // echo "Item removed from cart";
            } else {
                // echo "Item not found in cart";
            }
            break;

        case 'empty':
            // Empty the cart
            if (isset($_SESSION['cart'])) {
                unset($_SESSION['cart']);
            }
            // echo "Cart has been emptied";
            break;

        default:
            echo "Invalid cart operation";
            break;
    }
}
