    <section id="billboard" class="position-relative overflow-hidden bg-light-blue p-0">
        <div class="swiper main-swiper">
            <div class="swiper-wrapper home-slider" id="swiper-home">
                <?php
                    // $query_slider = "SELECT title, description, image, button, link FROM slider WHERE status = 1 ORDER BY id DESC LIMIT 4;";
                    if ($language !== 'english') {
                        $query_slider = "
                            SELECT 
                                slider.id, 
                                slider.image, 
                                slider.link, 
                                slider_translation.title AS title, 
                                slider_translation.description AS description, 
                                slider_translation.button AS button 
                            FROM 
                                slider
                            JOIN 
                                slider_translation ON slider.id = slider_translation.slider_id
                            JOIN 
                                languages ON slider_translation.language_id = languages.id
                            WHERE 
                                slider.status = 1 AND languages.name = '$language' 
                            ORDER BY id DESC LIMIT 4
                        ";
                    } else {
                        // Query for the 'slider' table ONLY
                        $query_slider = "SELECT title, description, image, button, link FROM slider WHERE status = 1 ORDER BY id DESC LIMIT 4";
                    }
                    $result_slider = $conn->query($query_slider);
                    if ($result_slider->num_rows > 0) {
                        $slider_data = $result_slider->fetch_all(MYSQLI_ASSOC);
                        foreach ($slider_data as $slider) :
                ?>
                    <div class="swiper-slide bg-slider swiper_direction" style="background: url('<?php echo $path_img . $slider['image']; ?>') center/cover no-repeat ; " >
                        <div class="container">
                            <div class="row d-flex align-items-center">
                                <div class="col-lg-8 col-md-12">
                                    <div class="banner-content">
                                        <h1 class="display-4 text-uppercase pb-5"><?php echo $slider['title']; ?></h1>
                                        <p><?php echo $slider['description']; ?></p>
                                        <a href="index.php?p=products" name="shop_product" class=" btn-medium btn-light text-uppercase rounded shopBtn"><?php echo $slider['button']; ?></a>
                                    </div>
                                </div>
                                
                            </div>
                        </div>
                    </div>
                <?php
                        endforeach;
                    } else {
                        echo "<p name='no_sliders'>No sliders found.</p>";
                    }
                ?>
            </div>
        </div>
        <div class="swiper-icon swiper-arrow swiper-arrow-prev">
            <svg class="chevron-left">
                <use xlink:href="#chevron-left" />
            </svg>
        </div>
        <div class="swiper-icon swiper-arrow swiper-arrow-next">
            <svg class="chevron-right">
                <use xlink:href="#chevron-right" />
            </svg>
        </div>
    </section>

    <!-- Service Start -->
    <!--<section id="company-services" class="padding-large">-->
    <!--  <div class="container">-->
    <!--    <div class="row">-->
    <!--      <div class="col-lg-3 col-md-6 pb-3">-->
    <!--        <div class="icon-box d-flex">-->
    <!--          <div class="icon-box-icon pe-3 pb-3">-->
    <!--            <svg class="cart-outline">-->
    <!--              <use xlink:href="#cart-outline" />-->
    <!--            </svg>-->
    <!--          </div>-->
    <!--          <div class="icon-box-content">-->
    <!--            <h3 class="card-title text-uppercase text-dark">Free delivery</h3>-->
    <!--            <p>Consectetur adipi elit lorem ipsum dolor sit amet.</p>-->
    <!--          </div>-->
    <!--        </div>-->
    <!--      </div>-->
    <!--      <div class="col-lg-3 col-md-6 pb-3">-->
    <!--        <div class="icon-box d-flex">-->
    <!--          <div class="icon-box-icon pe-3 pb-3">-->
    <!--            <svg class="quality">-->
    <!--              <use xlink:href="#quality" />-->
    <!--            </svg>-->
    <!--          </div>-->
    <!--          <div class="icon-box-content">-->
    <!--            <h3 class="card-title text-uppercase text-dark">Quality guarantee</h3>-->
    <!--            <p>Dolor sit amet orem ipsu mcons ectetur adipi elit.</p>-->
    <!--          </div>-->
    <!--        </div>-->
    <!--      </div>-->
    <!--      <div class="col-lg-3 col-md-6 pb-3">-->
    <!--        <div class="icon-box d-flex">-->
    <!--          <div class="icon-box-icon pe-3 pb-3">-->
    <!--            <svg class="price-tag">-->
    <!--              <use xlink:href="#price-tag" />-->
    <!--            </svg>-->
    <!--          </div>-->
    <!--          <div class="icon-box-content">-->
    <!--            <h3 class="card-title text-uppercase text-dark">Daily offers</h3>-->
    <!--            <p>Amet consectetur adipi elit loreme ipsum dolor sit.</p>-->
    <!--          </div>-->
    <!--        </div>-->
    <!--      </div>-->
    <!--      <div class="col-lg-3 col-md-6 pb-3">-->
    <!--        <div class="icon-box d-flex">-->
    <!--          <div class="icon-box-icon pe-3 pb-3">-->
    <!--            <svg class="shield-plus">-->
    <!--              <use xlink:href="#shield-plus" />-->
    <!--            </svg>-->
    <!--          </div>-->
    <!--          <div class="icon-box-content">-->
    <!--            <h3 class="card-title text-uppercase text-dark">100% secure payment</h3>-->
    <!--            <p>Rem Lopsum dolor sit amet, consectetur adipi elit.</p>-->
    <!--          </div>-->
    <!--        </div>-->
    <!--      </div>-->
    <!--    </div>-->
    <!--  </div>-->
    <!--</section>-->
    <!-- Service END -->

    <!-- Category Start -->
    <section id="category-products" class="product-store position-relative padding-large">
        <div class="container">
            <div class="row">
                <div class="display-header d-flex justify-content-between pb-3">
                    <h2 class="display-7 text-dark text-uppercase section_title" name="categories">Categories</h2>
                    <div class="btn-right">
                        <a href="index.php?p=categories" class="btn btn-normal text-uppercase more_lable" name="more">More</a>
                    </div>
                </div>

                <div class="col-md-12">
                    <div dir="" class="swiper category-swiper">
                        <div class="swiper-wrapper" id="category-list">
                            <?php
                            // $query_category = "SELECT id, name, image FROM category WHERE status = 1;";
                            if ($language !== 'english') {
                                // Query for the 'category_translation' table ONLY
                                $query_category = "
                                    SELECT 
                                        category.id, 
                                        category.image, 
                                        category.position, 
                                        category.parent_id, 
                                        category.date_created, 
                                        category_translation.name AS name 
                                    FROM 
                                        category
                                    JOIN 
                                        category_translation ON category.id = category_translation.category_id
                                    JOIN 
                                        languages ON category_translation.language_id = languages.id
                                    WHERE 
                                        category.status = 1 AND languages.name = '$language'
                                ";
                            } else {
                                // Query for the 'category' table ONLY
                                $query_category = "SELECT id, name, image FROM category WHERE status = 1 ";
                            }
                            $result_category = $conn->query($query_category);
                            if ($result_category->num_rows > 0) {
                                $category_data = $result_category->fetch_all(MYSQLI_ASSOC);
                                foreach ($category_data as $category) :
                            ?>
                                    <div class="swiper-slide">
                                        <div class="product-card position-relative">
                                            <a class="image-category" href="index.php?p=products&category_id=<?php echo $category['id']; ?>">
                                                <img src="<?php echo $path_img . $category['image']; ?>" alt="<?php echo $category['name']; ?>" class="img-fluid">
                                            </a>
                                            <div class="pt-3">
                                                <h3 class="card-title text-uppercase">
                                                    <a href="index.php?p=products&category_id=<?php echo $category['id']; ?>"><?php echo $category['name']; ?></a>
                                                </h3>
                                            </div>
                                        </div>
                                    </div>
                            <?php
                                endforeach;
                            } else {
                                echo "<p name='no_categories'>No categories found.</p>";
                            }
                            ?>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <div class="swiper-pagination position-absolute text-center"></div>
    </section>
    <!-- Category END -->

    <!-- Trending Start -->
    <section id="trend-products" class="product-store padding-large position-relative">
        <div class="container">
            <div class="row">
                <div class="display-header d-flex justify-content-between pb-3">
                    <h2 class="display-7 text-dark text-uppercase section_title" name="trending_products">Trending Products</h2>
                    <div class="btn-right">
                        <a href="index.php?p=products" class="btn btn-normal text-uppercase more_lable" name="more">More</a>
                    </div>
                </div>
                <div dir="" class="swiper trend-swiper">
                    <div class="swiper-wrapper" id="trend-container">
                        <?php
                        // $query_trend = "SELECT * FROM item WHERE status = 1 AND is_trending = 1 LIMIT 15;";
                        if ($language !== 'english') {
                            $query_trend = "
                                SELECT 
                                    item.id, 
                                    item.price, 
                                    item.image, 
                                    item.discount, 
                                    item.quantity, 
                                    item.date_created, 
                                    item.brand_id, 
                                    item.is_trending, 
                                    item.out_of_stock, 
                                    item.is_new, 
                                    item.category_id, 
                                    item.total_reviews, 
                                    item_translation.name AS name, 
                                    item_translation.description AS description, 
                                    ROUND(item.price - (item.price * (item.discount / 100)), 2) AS price_discount
                                FROM 
                                    item
                                JOIN 
                                    item_translation ON item.id = item_translation.item_id
                                JOIN 
                                    languages ON item_translation.language_id = languages.id
                                WHERE 
                                    item.status = 1 AND languages.name = '$language' AND item.is_trending = 1 
                                LIMIT 
                                    15
                            ";
                        } else {
                            $query_trend = "SELECT *, ROUND(price - (price * (discount / 100)), 2) AS price_discount FROM item WHERE status = 1 AND is_trending = 1 LIMIT 15";
                        }
                        $result_trend = $conn->query($query_trend);
                        if ($result_trend->num_rows > 0) {
                            $trend_data = $result_trend->fetch_all(MYSQLI_ASSOC);
                            foreach ($trend_data as $trendy) :
                                // Variables for dynamic content
                                $priceHTML = '';
                                if (empty($trendy['price_discount']) || $trendy['price_discount'] == 0 || $trendy['price'] == $trendy['price_discount']) {
                                    $priceHTML = '<span class="item-price text-primary">' . $currency . ' ' . $trendy['price'] . '</span>';
                                } else {
                                    $priceHTML = '
                                        <span class="item-price text-primary">' . $currency . ' ' . $trendy['price_discount'] . '</span>
                                        <del class="item-price">' . $currency . ' ' . $trendy['price'] . '</del>
                                    ';
                                }

                                $discountHTML = '';
                                if (!empty($trendy['discount']) && $trendy['discount'] != 0) {
                                    $discountHTML = '<p class="product-discount"><span class="smol" name="discount">Discount</span>: %' . $trendy['discount'] . '</p>';
                                }

                                $stockHTML = '';
                                if (!empty($trendy['out_of_stock']) && $trendy['out_of_stock'] == 1) {
                                    $stockHTML = '<p class="product-stock" name="out_of_stock">Out of stock</p>';
                                }
                        ?>
                                <div class="swiper-slide">
                                    <div class="product-card position-relative">
                                        <?php echo $discountHTML; ?>
                                        <?php echo $stockHTML; ?>
                                        <a class="image-holder" href="index.php?p=product&id=<?php echo $trendy['id']; ?>">
                                            <img src="<?php echo $path_img . $trendy['image']; ?>" alt="<?php echo $trendy['name']; ?>" class="img-fluid">
                                        </a>
                                        <div class="card-detail">
                                            <h5 class="card-title text-uppercase">
                                                <a href="index.php?p=product&id=<?php echo $trendy['id']; ?>"><?php echo $trendy['name']; ?></a>
                                            </h5>
                                            <?php echo $priceHTML; ?>
                                        </div>
                                    </div>
                                </div>
                        <?php
                            endforeach;
                        } else {
                            echo "<p name='no_trending'>No trendy products found.</p>";
                        }
                        ?>

                    </div>
                </div>
            </div>
        </div>
        <div class="swiper-pagination position-absolute text-center"></div>
    </section>
    <!-- Trending END -->

    <!-- Recently Start -->
    <section id="recent-products" class="product-store padding-large position-relative">
        <div class="container">
            <div class="row">
                <div class="display-header d-flex justify-content-between pb-3">
                    <h2 class="display-7 text-dark text-uppercase section_title" name="recently_added">Recently Added</h2>
                    <div class="btn-right">
                        <a href="index.php?p=products" class="btn btn-normal text-uppercase more_lable" name="more">More</a>
                    </div>
                </div>
                <div dir="" class="swiper recent-swiper">
                    <div class="swiper-wrapper" id="recent-container">
                        <?php
                        // $query_recent = "SELECT * FROM item WHERE status = 1 ORDER BY id DESC LIMIT 15;";
                        if ($language !== 'english') {
                            $query_recent = "
                                SELECT 
                                    item.id, 
                                    item.price, 
                                    item.image, 
                                    item.discount, 
                                    item.quantity, 
                                    item.date_created, 
                                    item.brand_id, 
                                    item.is_trending, 
                                    item.out_of_stock, 
                                    item.is_new, 
                                    item.category_id, 
                                    item.total_reviews, 
                                    item_translation.name AS name, 
                                    item_translation.description AS description, 
                                    ROUND(item.price - (item.price * (item.discount / 100)), 2) AS price_discount
                                FROM 
                                    item
                                JOIN 
                                    item_translation ON item.id = item_translation.item_id
                                JOIN 
                                    languages ON item_translation.language_id = languages.id
                                WHERE 
                                    item.status = 1 AND languages.name = '$language' 
                                ORDER BY item.id DESC LIMIT 15
                            ";
                        } else {
                            $query_recent = "SELECT *, ROUND(price - (price * (discount / 100)), 2) AS price_discount FROM item WHERE status = 1 ORDER BY id DESC LIMIT 15";
                        }
                        $result_recent = $conn->query($query_recent);
                        if ($result_recent->num_rows > 0) {
                            $recent_data = $result_recent->fetch_all(MYSQLI_ASSOC);
                            foreach ($recent_data as $recent) :
                                // Variables for dynamic content
                                $priceHTML = '';
                                if (empty($recent['price_discount']) || $recent['price_discount'] == 0 || $recent['price'] == $recent['price_discount']) {
                                    $priceHTML = '<span class="item-price text-primary">' . $currency . ' ' . $recent['price'] . '</span>';
                                } else {
                                    $priceHTML = '
                                        <span class="item-price text-primary">' . $currency . ' ' . $recent['price_discount'] . '</span>
                                        <del class="item-price">' . $currency . ' ' . $recent['price'] . '</del>
                                    ';
                                }

                                $discountHTML = '';
                                if (!empty($recent['discount']) && $recent['discount'] != 0) {
                                    $discountHTML = '<p class="product-discount"><span class="smol" name="discount">Discount</span>: %' . $recent['discount'] . '</p>';
                                }

                                $stockHTML = '';
                                if (!empty($recent['out_of_stock']) && $recent['out_of_stock'] == 1) {
                                    $stockHTML = '<p class="product-stock" name="out_of_stock">Out of stock</p>';
                                }
                        ?>
                                <div class="swiper-slide">
                                    <div class="product-card position-relative">
                                        <?php echo $discountHTML; ?>
                                        <?php echo $stockHTML; ?>
                                        <a class="image-holder" href="index.php?p=product&id=<?php echo $recent['id']; ?>">
                                            <img src="<?php echo $path_img . $recent['image']; ?>" alt="<?php echo $recent['name']; ?>" class="img-fluid">
                                        </a>
                                        <div class="card-detail">
                                            <h5 class="card-title text-uppercase">
                                                <a href="index.php?p=product&id=<?php echo $recent['id']; ?>"><?php echo $recent['name']; ?></a>
                                            </h5>
                                            <?php echo $priceHTML; ?>
                                        </div>
                                    </div>
                                </div>
                        <?php
                            endforeach;
                        } else {
                            echo "<p name='no_recents'>No newly added products found.</p>";
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="swiper-pagination position-absolute text-center"></div>
    </section>
    <!-- Recently END -->

    <!-- Banner Start -->
    <div id="banner" class="">
        <!--<div class="container">-->
        <!--    <div class="row d-flex flex-wrap align-items-center">-->
        <!--        <div class="col-md-6 col-sm-12">-->
        <!--            <div class="text-content">-->
        <!--                <h3>10% off</h3>-->
        <!--                <h2 class="display-2 pb-4 text-uppercase">New year sale</h2>-->
        <!--                <a href="#" class="btn btn-medium btn-light text-uppercase btn-rounded-none">Shop Sale</a>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
        <?php
            // $query_banner = "SELECT title, description, image FROM sections WHERE status = 1 ORDER BY id DESC LIMIT 1;";
            if ($language !== 'english') {
                $query_banner = "
                    SELECT 
                        sections.id, 
                        sections.image, 
                        section_translation.title AS title, 
                        section_translation.description AS description 
                    FROM 
                        sections
                    JOIN 
                        section_translation ON sections.id = section_translation.section_id
                    JOIN 
                        languages ON section_translation.language_id = languages.id
                    WHERE 
                        sections.status = 1 AND languages.name = '$language'
                ";
            } else {
                // Query for the 'sections' table ONLY
                $query_banner = "SELECT title, description, image FROM sections WHERE status = 1 ORDER BY id DESC LIMIT 1";
            }
            $result_banner = $conn->query($query_banner);
            if ($result_banner->num_rows > 0) {
                $banner_data = $result_banner->fetch_all(MYSQLI_ASSOC);
                foreach ($banner_data as $banner) :
        ?>
            <section class="bg-banner" style="background: url('<?php echo $path_img . $banner['image']; ?>') center no-repeat">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-md-8 text-center">
                            <h1 class="text-white text-uppercase"><?php echo $banner['title']; ?></h1>
                            <p><?php echo $banner['description']; ?></p>
                            <a href="index.php?p=products" name="shop_now" class="shopBtn">Shop Now</a>
                        </div>
                    </div>
                </div>
            </section>
        <?php
                endforeach;
            } else {
                // echo "<p name='no_banner'>No banner found.</p>";
            }
        ?>
    </div>
    <!-- Banner END -->

    <!-- Hot Start -->
    <section id="hot-products" class="product-store padding-large position-relative">
        <div class="container">
            <div class="row">
                <div class="display-header d-flex justify-content-between pb-3">
                    <h2 class="display-7 text-dark text-uppercase section_title" name="hot_offers">Hot Offers</h2>
                    <div class="btn-right">
                        <a href="index.php?p=products" class="btn btn-normal text-uppercase more_lable" name="more">More</a>
                    </div>
                </div>
                <div dir="" class="swiper hot-swiper">
                    <div class="swiper-wrapper" id="offer-container">
                        <?php
                        // $query_offer = "SELECT * FROM item WHERE status = 1 AND discount <> 0 LIMIT 15;";
                        if ($language !== 'english') {
                            $query_offer = "
                                SELECT 
                                    item.id, 
                                    item.price, 
                                    item.image, 
                                    item.discount, 
                                    item.quantity, 
                                    item.date_created, 
                                    item.brand_id, 
                                    item.is_trending, 
                                    item.out_of_stock, 
                                    item.is_new, 
                                    item.category_id, 
                                    item.total_reviews, 
                                    item_translation.name AS name, 
                                    item_translation.description AS description, 
                                    ROUND(item.price - (item.price * (item.discount / 100)), 2) AS price_discount
                                FROM 
                                    item
                                JOIN 
                                    item_translation ON item.id = item_translation.item_id
                                JOIN 
                                    languages ON item_translation.language_id = languages.id
                                WHERE 
                                    item.status = 1 AND languages.name = '$language' AND item.discount <> 0
                                LIMIT 
                                    15
                            ";
                        } else {
                            $query_offer = "SELECT *, ROUND(price - (price * (discount / 100)), 2) AS price_discount FROM item WHERE status = 1 AND discount <> 0 LIMIT 15";
                        }
                        $result_offer = $conn->query($query_offer);
                        if ($result_offer->num_rows > 0) {
                            $offer_data = $result_offer->fetch_all(MYSQLI_ASSOC);
                            foreach ($offer_data as $offer) :
                                // Variables for dynamic content
                                $priceHTML = '';
                                if (empty($offer['price_discount']) || $offer['price_discount'] == 0 || $offer['price'] == $offer['price_discount']) {
                                    $priceHTML = '<span class="item-price text-primary">' . $currency . ' ' . $offer['price'] . '</span>';
                                } else {
                                    $priceHTML = '
                                        <span class="item-price text-primary">' . $currency . ' ' . $offer['price_discount'] . '</span>
                                        <del class="item-price">' . $currency . ' ' . $offer['price'] . '</del>
                                    ';
                                }

                                $discountHTML = '';
                                if (!empty($offer['discount']) && $offer['discount'] != 0) {
                                    $discountHTML = '<p class="product-discount"><span class="smol" name="discount">Discount</span>: %' . $offer['discount'] . '</p>';
                                }

                                $stockHTML = '';
                                if (!empty($offer['out_of_stock']) && $offer['out_of_stock'] == 1) {
                                    $stockHTML = '<p class="product-stock" name="out_of_stock">Out of stock</p>';
                                }
                        ?>
                                <div class="swiper-slide">
                                    <div class="product-card position-relative">
                                        <?php echo $discountHTML; ?>
                                        <?php echo $stockHTML; ?>
                                        <a class="image-holder" href="index.php?p=product&id=<?php echo $offer['id']; ?>">
                                            <img src="<?php echo $path_img . $offer['image']; ?>" alt="<?php echo $offer['name']; ?>" class="img-fluid">
                                        </a>
                                        <div class="card-detail">
                                            <h5 class="card-title text-uppercase">
                                                <a href="index.php?p=product&id=<?php echo $offer['id']; ?>"><?php echo $offer['name']; ?></a>
                                            </h5>
                                            <?php echo $priceHTML; ?>
                                        </div>
                                    </div>
                                </div>
                        <?php
                            endforeach;
                        } else {
                            echo "<p name='no_offers'>No offer products found.</p>";
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="swiper-pagination position-absolute text-center"></div>
    </section>
    <!-- Hot END -->
    
<script>

let language_api;

$(document).ready(function() {
    
    language_api = '&language=' + language;

    // console.log("language_api: " + language_api);
    
    // fetchSlider();
    // fetchBanner();
    // fetchCategory();
    // fetchItemsTrend();
    // fetchItemsRecent();
    // fetchItemsOffer();
    
});

function fetchSlider() {
    console.log("<?php echo $path_api; ?>slider.php?language=" + language);
  $.ajax({
    url: "<?php echo $path_api; ?>slider.php?language=" + language,
    type: "GET",
    dataType: "json",
    success: function (data) {
      if (data.success) {
        const swiperHome = $("#swiper-home");
        let swiperHTML = "";

        $.each(data.objects, function (index, slider) {
          swiperHTML += `
    <div class="swiper-slide bg-slider" style="background: url('${slider.image}') center/cover no-repeat">
        <div class="container">
            <div class="row d-flex align-items-center">
                <div class="col-lg-8 col-md-12">
                    <div class="banner-content">
                        <h1 class="display-4 text-uppercase pb-5">${slider.title}</h1>
                        <a href="index.php?p=products" name="shop_product" class="btn btn-medium btn-light text-uppercase rounded">${slider.button}</a>
                    </div>
                </div>
                
            </div>
        </div>
    </div>
    `;
    // <div class="col-md-5">
    //                 <div class="">
    //                     <img src="${slider.image}" alt="${slider.title}">
    //                 </div>
    //             </div>
        });
        swiperHome.html(swiperHTML);
      }
    },
    error: function (xhr, status, error) {
      console.error("Error fetching products:", error);
    },
  });
}

// function fetchBanner() {
//   $.ajax({
//     url: "<?php echo $path_api; ?>banner.php",
//     type: "POST",
//     dataType: "json",
//     data: {
//       id: 1
//     //   language: language
//     },
//     success: function (data) {
//         console.log("In Success");
//       if (data.success) {
//           console.log("In data Success");
//         const bannerHome = $("#banner");
//         bannerHome.html(data.html);
//       }
//     },
//     error: function (xhr, status, error) {
//       console.log("Error fetching banner:", error);
//     },
//   });
// }

function fetchBanner() {
    const bannerHome = $("#banner");
    
    // Since it should be dynamic later on
    section_id = 1;
    
    let urlBanner = '<?php echo $path_api; ?>banner.php?id=' + section_id + language_api;
    
    // console.log("urlBanner: " + urlBanner);
    
  $.ajax({
    url: urlBanner,
    type: "GET",
    dataType: "json",
    // data: {
    //   id: 1,
    // //   language: language
    // },
    success: function (data) {
        // console.log("in success");
      if (data.success) {
        //   console.log("in data.success");
        bannerHome.html(data.html);
      } else{
          console.log("some error in sending");
      }
    },
    error: function (xhr, status, error) {
      console.error("Error fetching banner:", error);
    //   console.log("Error status:", status);
    //   console.log("Error xhr:", xhr);
    },
  });
}

function fetchCategory() {
  $.ajax({
    url: '<?php echo $path_api; ?>category.php?language=' + language,
    type: 'GET',
    dataType: 'json',
    success: function(data) {
      if (data.success) {
        const categoryList = $('#category-list');
        let categoryHTML = '';

        $.each(data.objects, function(index, category) {
          categoryHTML += `
            <div class="swiper-slide">
                <div class="product-card position-relative">
                    <a class="image-category" href="index.php?p=products&category_id=${category.id}">
                        <img src="${category.image}" alt="${category.name}" class="img-fluid">
                    </a>
                    <div class="pt-3">
                        <h3 class="card-title text-uppercase">
                            <a href="index.php?p=products&category_id=${category.id}">${category.name}</a>
                        </h3>
                    </div>
                </div>
            </div>
            `;
        });
        categoryList.html(categoryHTML);
      }
    },
    error: function(xhr, status, error) {
      console.error('Error fetching products:', error);
    }
  });
}

function fetchItemsTrend() {
    let page = '1';
    let limit = '&limit=8';
    let filter_trend = '&is_trending=1';

    let urlItemsTrend = '<?php echo $path_api; ?>item.php?page=' + page + limit + filter_trend + language_api;
    urlItemsTrend = urlItemsTrend.slice(-1) === '&' ? urlItemsTrend.slice(0, -1) : urlItemsTrend;

    console.log("urlItemsTrend: " + urlItemsTrend);

    $.ajax({
        url: urlItemsTrend,
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            const $trendContainer = $('#trend-container');
            let trendHTML = '';

            if (data.success && data.objects.length > 0) {
                $.each(data.objects, function(index, trend) {
                    let priceHTML = '';
    
                    // Check if price_discount is null, empty, or 0
                    if (!trend.price_discount || trend.price_discount == 0) {
                        priceHTML = `<span class="item-price text-primary"><?php echo $currency; ?> ${trend.price}</span>`;
                    } else {
                        priceHTML = `
                            <span class="item-price text-primary"><?php echo $currency; ?> ${trend.price_discount}</span>
                            <del class="item-price"><?php echo $currency; ?> ${trend.price}</del>
                        `;
                    }
                    
                    let discountHTML = '';
                    if (trend.discount != 0) {
                        discountHTML = `<p class="product-discount"><span class="smol" name="discount">Discount</span>: %${trend.discount}</p>`;
                    }
                    let stockHTML = '';
                        if (trend.out_of_stock == 1) {
                        stockHTML = `<p class="product-stock" name="out_of_stock">Out of stock</p>`;
                    }

                    trendHTML += `
                        <div class="swiper-slide">
                            <div class="product-card position-relative">
                                ${discountHTML}
                                ${stockHTML}
                                <a class="image-holder" href="index.php?p=product&id=${trend.id}">
                                    <img src="${trend.image[0]}" alt="${trend.name}" class="img-fluid">
                                </a>
                                <div class="">
                                    
                                </div>
                                <div class="card-detail">
                                    <h3 class="card-title text-uppercase">
                                        <a href="index.php?p=product&id=${trend.id}">${trend.name}</a>
                                    </h3>
                                    ${priceHTML}
                                </div>
                            </div>
                        </div>
                    `;
                });

                $trendContainer.html(trendHTML);
            } else {
                $trendContainer.html('<h6 name="no_trending">No Trending Items</h6>');
            }
        },
        error: function(xhr, status, error) {
            console.error('Error fetching products:', error);
            $('#trend-container').html('<h6 name="no_trending">No Trending Items</h6>');
        }
    });
}

function fetchItemsRecent() {
    let page = '1';
    let limit = '&limit=8';
    let filter_date = '&sort_date=date_desc';

    let urlItemsRecent = '<?php echo $path_api; ?>item.php?page=' + page + limit + filter_date + language_api;
    urlItemsRecent = urlItemsRecent.slice(-1) === '&' ? urlItemsRecent.slice(0, -1) : urlItemsRecent;

    // console.log("urlItemsRecent: " + urlItemsRecent);

    $.ajax({
        url: urlItemsRecent,
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            const $recentContainer = $('#recent-container');
            let recentHTML = '';

            if (data.success && data.objects.length > 0) {
                $.each(data.objects, function(index, recent) {
                    let priceHTML = '';

                    // Check if price_discount is null, empty, or 0
                    if (!recent.price_discount || recent.price_discount == 0) {
                        priceHTML = `<span class="item-price text-primary"><?php echo $currency; ?> ${recent.price}</span>`;
                    } else {
                        priceHTML = `
                            <span class="item-price text-primary"><?php echo $currency; ?> ${recent.price_discount}</span>
                            <del class="item-price"><?php echo $currency; ?> ${recent.price}</del>
                        `;
                    }
                    
                    let discountHTML = '';
                    if (recent.discount != 0) {
                        discountHTML = `<p class="product-discount"><span class="smol" name="discount">Discount</span>: %${recent.discount}</p>`;
                    }
                    let stockHTML = '';
                        if (recent.out_of_stock == 1) {
                        stockHTML = `<p class="product-stock" name="out_of_stock">Out of stock</p>`;
                    }

                    recentHTML += `
                        <div class="swiper-slide">
                            <div class="product-card position-relative">
                                ${discountHTML}
                                ${stockHTML}
                                <a class="image-holder" href="index.php?p=product&id=${recent.id}">
                                    <img src="${recent.image[0]}" alt="${recent.name}" class="img-fluid">
                                </a>
                                <div class="">
                                    
                                </div>
                                <div class="card-detail">
                                    <h3 class="card-title text-uppercase">
                                        <a href="index.php?p=product&id=${recent.id}">${recent.name}</a>
                                    </h3>
                                    ${priceHTML}
                                </div>
                            </div>
                        </div>
                    `;
                });
                $recentContainer.html(recentHTML);
            } else {
                $recentContainer.html('<h6 name="no_recents">No Recent Items</h6>');
            }
        },
        error: function(xhr, status, error) {
            console.error('Error fetching products:', error);
            $('#recent-container').html('<h6 name="no_recents">No Recent Items</h6>'); // Optional fallback for API errors
        }
    });
}

function fetchItemsOffer() {
    let page = '1';
    let limit = '&limit=8';
    let filter_discount = '&discount=1';

    let urlItemsOffer = '<?php echo $path_api; ?>item.php?page=' + page + limit + filter_discount + language_api;
    urlItemsOffer = urlItemsOffer.slice(-1) === '&' ? urlItemsOffer.slice(0, -1) : urlItemsOffer;

    // console.log("urlItemsOffer: " + urlItemsOffer);

    $.ajax({
        url: urlItemsOffer,
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            const $offerContainer = $('#offer-container');
            let offerHTML = '';

            if (data.success && data.objects.length > 0) {
                $.each(data.objects, function(index, offer) {
                    let priceHTML = '';
    
                    // Check if price_discount is null, empty, or 0
                    if (!offer.price_discount || offer.price_discount == 0) {
                        priceHTML = `<span class="item-price text-primary"><?php echo $currency; ?> ${offer.price}</span>`;
                    } else {
                        priceHTML = `
                            <span class="item-price text-primary"><?php echo $currency; ?> ${offer.price_discount}</span>
                            <del class="item-price"><?php echo $currency; ?> ${offer.price}</del>
                        `;
                    }
                    
                    let discountHTML = '';
                    if (offer.discount != 0) {
                        discountHTML = `<p class="product-discount"><span class="smol" name="discount">Discount</span>: %${offer.discount}</p>`;
                    }
                    let stockHTML = '';
                        if (offer.out_of_stock == 1) {
                        stockHTML = `<p class="product-stock" name="out_of_stock">Out of stock</p>`;
                    }

                    offerHTML += `
                        <div class="swiper-slide">
                            <div class="product-card position-relative">
                                ${discountHTML}
                                ${stockHTML}
                                <a class="image-holder" href="index.php?p=product&id=${offer.id}">
                                    <img src="${offer.image[0]}" alt="${offer.name}" class="img-fluid">
                                </a>
                                <div class="">
                                    
                                </div>
                                <div class="card-detail">
                                    <h3 class="card-title text-uppercase">
                                        <a href="index.php?p=product&id=${offer.id}">${offer.name}</a>
                                    </h3>
                                    ${priceHTML}
                                </div>
                            </div>
                        </div>
                    `;
                });
                $offerContainer.html(offerHTML);
            } else {
                $offerContainer.html('<h6 name="no_offers">No Offers</h6>');
            }
        },
        error: function(xhr, status, error) {
            console.error('Error fetching products:', error);
            $('#offer-container').html('<h6 name="no_offers">No Offers</h6>');
        }
    });
}

</script>
