<?php
include_once("../connect.php");
if (isset($_GET["order_id"])) {
    $order_id = $_GET["order_id"];
} else {
    echo '<script>
            window.location.href = "../index.php?p=home";
          </script>';
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Invoice</title>
    <link rel="stylesheet" href="style.css?v=<?php strtotime(0) ?>" media="all" />
</head>

<body>
    <div id="myDiv">
        <header class="clearfix">
            <div id="logo">
                <img src="../assets/uploads/logo.png" style="max-width: 100px; height: auto" alt="Logo">
            </div>
            <div id="company">
                <h2 class="name">Lamasat Qatar</h2>
                <div class="contactInfo"><a href="tel:97450327790">5032 7790</a></div>
                <div class="contactInfo"><a href="mailto:info@lamassat-qatar.com">info@lamassat-qatar.com</a></div>
            </div>
        </header>
        <main>
            <div id="details" class="clearfix">
                <div id="client">
                    <div class="to">INVOICE TO:</div>
                    <b>Client Name:</b>
                        <span id="client_name"></span>
                    <div class="email">
                        <b>Client Email:</b>
                        <span id="client_email"></span>
                    </div>
                    <div class="email">
                        <b>Client Phone:</b>
                        <span id="client_phone"></span>
                    </div>

                    <div class="address">
                        <b>Client Address:</b>
                        <span id="client_address" ></span>
                    </div>
                </div>
                <div id="invoice">
                    <h1 id="invoice_id">INVOICE #Inv-<?php echo $order_id; ?></h1>
                    <div class="date">Date of Invoice: <span id="date_order"></span> </div>
                </div>
            </div>
            <table border="0" cellspacing="0" cellpadding="0">
                <thead>

                    <tr style="background-color:whitesmoke">

                        <th>Item Code</th>
                        <th>Item Name</th>
                        <th>Color</th>
                        <th>Size</th>
                        <th>Unit Price</th>
                        <th>Quantity</th>
                        <th>Amount</th>

                    </tr>

                </thead>
                <tbody id="order_invoice">
                    <tr>
                        <td>item id</td>
                        <td>item name</td>
                        <td>item color</td>
                        <td>item size</td>
                        <td>unit price</td>
                        <td>Quantity</td>
                        <td>amount price of this item</td>
                    </tr>
                </tbody>
                
                <tfoot>

                    <tr>
                        <td colspan="3"></td>
                        <td colspan="3">Sub Total</td>
                        <td id="order_subtotal"></td>
                    </tr>

                    <tr>
                        <td colspan="3"></td>
                        <td colspan="3">Discount</td>
                        <td id="order_discount">0%</td>
                    </tr>

                    <tr>
                        <td colspan="3"></td>
                        <td colspan="3">TOTAL</td>
                        <td id="order_total"></td>
                    </tr>
                </tfoot>
            </table>
            <div>

            </div>
            <div id="thanks">Thank you!</div>
            <div id="notices">
                <div>COMMENT:</div>
                <p id="notes">
                    
                </p>
                <div class="notice" style="display:none;">A finance charge of 1.5% will be made on unpaid balances after 30 days.</div>
            </div>
        </main>
        <footer>
            Invoice was created on our system and is valid without the signature and seal, please keep it, and remember the invoice id.
        </footer>
    </div>
    <button onclick="printDiv()" class="btn" style="float:right;    padding: 5px 20px;
">Print</button>

<script src="../assets/js/jquery-1.11.0.min.js"></script>

</body>

</html>


<script>

    function printDiv() {
        window.print();
    }

$(document).ready(function() {
    fetchInvoice();
});

function fetchInvoice() {
    const order_id = '<?php echo $order_id; ?>';
    
    $.ajax({
        url: '<?php echo $path_api; ?>invoice.php',
        type: 'POST',
        dataType: 'json',
        data: JSON.stringify({
            order_id: order_id
        }),
        contentType: 'application/json',
        success: function(response) {
            if (response.success) {
                const $invoiceTable = $('#order_invoice');
                const $orderTotal = $('#order_total');
                const $orderDiscount = $('#order_discount');
                const $orderSubTotal = $('#order_subtotal');
                const $clientName = $('#client_name');
                const $clientPhone = $('#client_phone');
                const $clientEmail = $('#client_email');
                const $clientAddress = $('#client_address');
                const $dateOrder = $('#date_order');
                const $notes = $('#notes');
                
                // Clear the previous content
                $invoiceTable.empty();
                let tableHTML = '';

                // Loop through all the items and append rows to the table
                $.each(response.items, function(index, item) {
                    tableHTML += `
                        <tr>
                            <td>${item.item_id}</td>
                            <td>${item.item_name}</td>
                            <td>${item.color_name}</td>
                            <td>${item.size_name}</td>
                            <td>QAR ${item.discounted_price_per_item.toFixed(2)}</td>
                            <td>${item.quantity}</td>
                            <td>QAR ${item.total_price.toFixed(2)}</td>
                        </tr>
                    `;
                });

                // Add the rows to the table body
                $invoiceTable.html(tableHTML);
                
                // Update the total price
                $orderSubTotal.text('QAR ' + response.order_total.toFixed(2));
                $orderDiscount.text('%' + response.coupon_discount);
                $orderTotal.text('QAR ' + response.order_total_after_coupon.toFixed(2));
                
                // Updating Client Info
                $clientName.text(response.client.name);
                $clientPhone.text(response.client.phone_number);
                $clientEmail.text(response.client.email);
                $clientAddress.text(response.client.address);
                
                // Invoice Info
                $dateOrder.text(response.date_order);
                console.log("notes: "+ response.client.notes);
                // $notes.text(response.client.notes);
                
            } else {
                console.log(response.message);
            }
        },
        error: function(xhr, status, error) {
            console.error('Error fetching invoice:', error);
        }
    });
}


</script>