<?php

$category_id = "";
$itemsPerPage = 12;
$current_page = isset($_GET['page_no']) ? intval($_GET['page_no']) : 1;
$offset = ($current_page - 1) * $itemsPerPage;

if (isset($_GET['page_no']) && $_GET['page_no'] != "") {
    $page_no = $_GET['page_no'];
} else {
    $page_no = 1;
}

$total_records_per_page = 12;
$offset = ($page_no - 1) * $total_records_per_page;
$previous_page = $page_no - 1;
$next_page = $page_no + 1;
$adjacents = "2";

$criteria = '';

if (isset($_GET["category_id"]) && is_array($_GET["category_id"])) {
    $category_ids = implode(',', array_map('intval', $_GET['category_id']));
    $criteria .= ' and category_id IN (' . $category_ids . ')';
}

// if (isset($_GET["search"]) && $_GET["search"] !== "") {
//     $criteria .= " AND i.name LIKE '%" . $_GET["search"] . "%'";
// }

$criteria_order_items = "order by i.id desc";

if (isset($_GET["sort_items"]) && $_GET["sort_items"] !== "") {
    $sort_items = $_GET["sort_items"];
    if ($sort_items == 1) {
        $criteria_order_items = "order by  i.price asc";
    } else if ($sort_items == 2) {
        $criteria_order_items = "order by  i.price desc";
    }

    if ($sort_items == 3) {
        $criteria_order_items = "order by  i.date_created desc";
    } else if ($sort_items == 4) {
        $criteria_order_items = "order by i.date_created asc";
    }
    
    if ($sort_items == 5) {
        $criteria_order_items = "AND i.is_trending = 1";
    } else if ($sort_items == 6) {
        $criteria_order_items = "AND i.discount <> 0";
    }
}
// $language = "arabic";
// echo $language;
if ($language !== 'english') {
    $query = "
        SELECT 
            i.id, 
            i.price, 
            i.image, 
            i.discount, 
            i.quantity, 
            i.out_of_stock, 
            i.category_id, 
            item_translation.name AS name, 
            item_translation.description AS description, 
            ROUND(i.price - (i.price * (i.discount / 100)), 2) AS price_discount
        FROM 
            `item` i 
        JOIN 
            `category` c ON c.id = i.category_id
        JOIN 
            `item_translation` ON i.id = item_translation.item_id
        JOIN 
            `languages` ON item_translation.language_id = languages.id
        WHERE 
            i.status = 1 
            AND languages.name = '$language' 
            $criteria 
            $criteria_order_items 
        LIMIT $offset, $itemsPerPage";
} else {
    $query = "
        SELECT 
            i.id, 
            i.name, 
            i.image, 
            i.description, 
            i.price, 
            i.discount, 
            i.out_of_stock, 
            i.category_id, 
            ROUND(i.price - (i.price * (i.discount / 100)), 2) AS price_discount
        FROM 
            `item` i
        JOIN 
            `category` c ON c.id = i.category_id
        WHERE 
            i.status = 1 
            $criteria 
            $criteria_order_items 
        LIMIT $offset, $itemsPerPage";
}


// echo $query;

$query_count = " SELECT count(*) as total
    FROM item i , category c 
    WHERE i.status = 1 and i.category_id = c.id  $criteria";

$result_count = $conn->query($query_count);
$row_count = $result_count->fetch_assoc();
$total_items = $row_count['total'];
$total_pages = ceil($total_items / $itemsPerPage);
?>

<!-- ======= Hero Section ======= -->
<section class="bg-bread">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1 class="" name="products">Products</h1>
                <h4 class=""><span name="home">Home</span> / <span name="products">Products</span></h4>
            </div>
        </div>
    </div>
</section>
<!-- ====== End Hero Section ====== -->

<!-- products -->
<section class="product-section">
    <div class="container">
        <div class="row">
            
            <div class="col-md-3">
                
                <!-- Toggle Button -->
                <button id="filter-toggle-btn">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                        <path d="M488 0H24C2.7 0-8 25.9 7.1 41L192 225.9V432c0 7.8 3.8 15.2 10.2 19.7l80 56C298 518.7 320 507.5 320 488V225.9l184.9-185C520 25.9 509.3 0 488 0z"/>
                    </svg>
                </button>

                <!-- Overlay -->
                <div class="filter-overlay"></div>
                
                <!-- Side Menu -->
                <div class="filter-sidemenu">
                    <form type="submit" method="GET" action="index.php?p=products" class="filterForm">
                        <button type="button" id="filter-toggle-close">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 352 512">
                                <path d="M242.7 256l100.1-100.1c12.3-12.3 12.3-32.2 0-44.5l-22.2-22.2c-12.3-12.3-32.2-12.3-44.5 0L176 189.3 75.9 89.2c-12.3-12.3-32.2-12.3-44.5 0L9.2 111.5c-12.3 12.3-12.3 32.2 0 44.5L109.3 256 9.2 356.1c-12.3 12.3-12.3 32.2 0 44.5l22.2 22.2c12.3 12.3 32.2 12.3 44.5 0L176 322.7l100.1 100.1c12.3 12.3 32.2 12.3 44.5 0l22.2-22.2c12.3-12.3 12.3-32.2 0-44.5L242.7 256z"/>
                            </svg>
                        </button>
                        <h2 name="item_filter">Item Filter</h2>
                        <hr>
                        <input type="hidden" name="p" value="products">
                        <h6 name="sort_price">Sort By Price</h6>
                        <ul class="">
                            <li>
                                <input type="radio" value="1" <?php if (isset($_GET["sort_items"]) && $_GET["sort_items"] == "1") {
                                                                    echo "checked";
                                                                } ?> name="sort_items"  class="clear_filter">
                                    <span name="low_high">Low to High</span>
                                </li>
                           <li>
                                <input type="radio" value="2" <?php if (isset($_GET["sort_items"]) && $_GET["sort_items"] == "2") {
                                                                    echo "checked";
                                                                } ?> name="sort_items" class="clear_filter">
                                <span name="high_low">High to Low</span>
                            </li>
                        </ul>
                        <h6 name="sort_date">Sort By Date</h6>
                        <ul class="">
                            <li>
                                <input type="radio" value="3" <?php if (isset($_GET["sort_items"]) && $_GET["sort_items"] == "3") {
                                                                    echo "checked";
                                                                } ?> name="sort_items" class="clear_filter">
                                <span name="old_new">Oldest to Newest</span>
                            </li>
                            <li>
                                <input type="radio" value="4" <?php if (isset($_GET["sort_items"]) && $_GET["sort_items"] == "4") {
                                                                    echo "checked";
                                                                } ?> name="sort_items" class="clear_filter">
                                <span name="new_old">Newest to Oldest</span>
                            </li>
                        </ul>
                        <h6 name="sort_popularity">Sort By Popularity</h6>
                        <ul class="">
                            <li>
                                <input type="radio" value="5" <?php if (isset($_GET["sort_items"]) && $_GET["sort_items"] == "5") {
                                                                    echo "checked";
                                                                } ?> name="sort_items" class="clear_filter">
                                <span name="trending">Trending</span>
                            </li>
                            <li>
                                <input type="radio" value="6" <?php if (isset($_GET["sort_items"]) && $_GET["sort_items"] == "6") {
                                                                    echo "checked";
                                                                } ?> name="sort_items" class="clear_filter">
                                <span name="offers">Offers</span>
                            </li>
                        </ul>
                        <h6 name="sort_category">Sort By Category</h6>
                        <ul class="">
                            <?php
                            if ($language !== 'english') {
                                $query_category = "
                                    SELECT 
                                        c.*, 
                                        COUNT(it.id) AS item_count, 
                                        category_translation.name AS name
                                    FROM 
                                        category c
                                    LEFT JOIN 
                                        item it ON c.id = it.category_id
                                    LEFT JOIN 
                                        category_translation ON c.id = category_translation.category_id
                                    WHERE 
                                        category_translation.language_id = (SELECT id FROM languages WHERE name = '$language')
                                    GROUP BY 
                                        c.id;
                                ";

                            } else {
                                $query_category = "SELECT c.*, COUNT(it.id) AS item_count
                                        FROM category c 
                                        LEFT JOIN item it ON c.id = it.category_id 
                                        GROUP BY c.id;";
                            }
                        
                            // echo $query_category;
                            $result_category = $conn->query($query_category);

                            if ($result_category) {
                                while ($row_category = $result_category->fetch_assoc()) {
                            ?>
                                    <li>
                                        <input type="checkbox" id="<?php echo $row_category["id"]; ?>c" name="category_id[]" value="<?php echo $row_category['id']; ?>"
                                                <?php
                                                if ((isset($_GET["category_id"]) && is_array($_GET["category_id"]) && in_array($row_category["id"], $_GET["category_id"])) || ($row_category["id"] == $category_id)) {
                                                    echo 'checked="checked"';
                                                }
                                                ?>>
                                        <label for="<?php echo $row_category['id']; ?>c">
                                            <?php echo $row_category['name']; ?>
                                        </label>
                                    </li>
                            <?php
                                }
                            } else {
                            }
                            ?>

                        </ul>
                        <div class="col-md-12">
                            <!--<input type="submit" name="submit" class="sendBtn" id="submitfilter" value="filter">-->
                            <button id="filter-btn" name="filter" class="shopBtn mb-2" type="submit">Filter</button>
                            <a type="reset" href="index.php?p=products" class="shopBtn mb-2" name="clear_filter">Clear Filter</a>
                        </div>
                    </form>
                </div>
                
            </div> 
            
            <div class="col-md-9 mt-4">
                <div class="row">
                    <?php
                    if ($total_items == 0) {
                        // echo '<p style="text-align: center; margin: 0 auto;">No Results Found</p>';
                    }

                    $result = $conn->query($query);
                    // var_dump($result);
                        if ($result->num_rows > 0) {
                            $data = $result->fetch_all(MYSQLI_ASSOC);
                            foreach ($data as $row) :
                                // Variables for dynamic content
                                $priceHTML = '';
                                if (empty($row['price_discount']) || $row['price_discount'] == 0 || $row['price'] == $row['price_discount']) {
                                // Display only the main price if there's no discount or price_discount equals price duhhh
                                $priceHTML = '<span id="" class="item-price text-primary">' . $currency . ' ' . number_format($row['price'], 2) . '</span>';
                                } else {
                                    // Display discounted price with the original price
                                    $priceHTML = '
                                        <span id="" class="item-price text-primary">' . $currency . ' ' . number_format($row['price_discount'], 2) . '</span>
                                        <del id="" class="item-price">' . $currency . ' ' . number_format($row['price'], 2) . '</del>
                                    ';
                                }

                                $discountHTML = '';
                                if (!empty($row['discount']) && $row['discount'] != 0) {
                                    $discountHTML = '<p class="product-discount"><span class="smol" name="discount">Discount</span>: %' . $row['discount'] . '</p>';
                                }

                                $stockHTML = '';
                                if (!empty($row['out_of_stock']) && $row['out_of_stock'] == 1) {
                                    $stockHTML = '<p class="product-stock" name="out_of_stock">Out of stock</p>';
                                }
                        ?>
                                <div class="col-xl-3 col-lg-4 col-md-6 mb-4">
                                    <div class="product-card position-relative">
                                        <?php echo $discountHTML; ?>
                                        <?php echo $stockHTML; ?>
                                        <a class="image-holder" href="index.php?p=product&id=<?php echo $row['id']; ?>">
                                            <img src="<?php echo $path_img . $row['image']; ?>" alt="<?php echo $row['name']; ?>" class="img-fluid">
                                        </a>
                                        <div class="card-detail">
                                            <h5 class="card-title text-uppercase">
                                                <a href="index.php?p=product&id=<?php echo $row['id']; ?>"><?php echo $row['name']; ?></a>
                                            </h5>
                                            <?php echo $priceHTML; ?>
                                        </div>
                                    </div>
                                </div>
                        <?php
                            endforeach;
                        } else {
                            echo "<p name='no_products'>No products found.</p>";
                        }
                        ?>
                </div>

            </div>
        </div>
        <?php

        $params = $_GET;
        $link_pagination = "";
        unset($params['page_no']);
        if (!empty($params)) {
            $link_pagination .= http_build_query($params) . '&';
        }
        $link_pagination = "index.php?$link_pagination&page_no";
        $total_no_of_pages = ceil($total_items / $total_records_per_page);
        $second_last = $total_no_of_pages - 1;
        ?>
        <div class="container">
            <div class="pagination_div" <?php if ($total_items < $total_records_per_page) {
                                            echo "style='text-align: center;display:none'";
                                        } ?>>
                <ul class="pagination" style="      overflow-x: scroll; ">
                    <?php
                    if ($page_no > 1) {
                        echo "<a href='$link_pagination=1'><li name='first_page'>First Page</li></a>";
                    } ?>

                    <a <?php if ($page_no > 1) {
                            echo "href='$link_pagination=$previous_page'";
                        } ?>>
                        <li <?php if ($page_no <= 1) {
                                echo "class='disabled'";
                            } ?> name="previous">Previous</li>
                    </a>
                    <?php
                    if ($total_no_of_pages <= 10) {
                        for ($counter = 1; $counter <= $total_no_of_pages; $counter++) {
                            if ($counter == $page_no) {
                                echo "<a><li class='active'>$counter</li></a>";
                            } else {
                                echo "<a href='$link_pagination=$counter'><li>$counter</li></a>";
                            }
                        }
                    } elseif ($page_no > 4 && $page_no < $total_no_of_pages - 4) {
                        echo "<a href='$link_pagination=1'><li>1</li></a>";
                        echo "<a href='$link_pagination=2'><li>2</li></a>";
                        echo "<li><a>...</a></li>";
                        for (
                            $counter = $page_no - $adjacents;
                            $counter <= $page_no + $adjacents;
                            $counter++
                        ) {
                            if ($counter == $page_no) {
                                echo "<a><li class='active'>$counter</li></a>";
                            } else {
                                echo "<a href='$link_pagination=$counter'><li>$counter</li></a>";
                            }
                        }
                        echo "<li><a>...</a></li>";
                        echo "<a href='$link_pagination=$second_last'><li>$second_last</li></a>";
                        echo "<a href='$link_pagination=$total_no_of_pages'><li>$total_no_of_pages</li></a>";
                    } else if ($page_no <= 4) {
                        for ($counter = 1; $counter < 8; $counter++) {
                            if ($counter == $page_no) {
                                echo "<a><li class='active'>$counter</li></a>";
                            } else {
                                echo "<a href='$link_pagination=$counter'><li>$counter</li></a>";
                            }
                        }
                        echo "<li><a>...</a></li>";
                        echo "<a href='$link_pagination=$second_last'><li>$second_last</li></a>";
                        echo "<a href='$link_pagination=$total_no_of_pages'><li>$total_no_of_pages</li></a>";
                    } else {
                        echo "<a href='$link_pagination=1'><li>1</li></a>";
                        echo "<a href='$link_pagination=2'><li>2</li></a>";
                        echo "<li><a>...</a></li>";
                        for (
                            $counter = $total_no_of_pages - 6;
                            $counter <= $total_no_of_pages;
                            $counter++
                        ) {
                            if ($counter == $page_no) {
                                echo "<a><li class='active'>$counter</li></a>";
                            } else {
                                echo "<a href='$link_pagination=$counter'><li>$counter</li></a>";
                            }
                        }
                    }
                    ?>
                    <a <?php if ($page_no < $total_no_of_pages) {
                            echo "href='$link_pagination=$next_page'";
                        } ?>>
                        <li <?php if ($page_no >= $total_no_of_pages) {
                                echo "class='disabled'";
                            } ?> name="next" >Next</li>
                    </a>
                    <?php
                    if ($page_no < $total_no_of_pages) {
                        echo "<a href='$link_pagination=$total_no_of_pages'> <li name='last_page'> Last Page </li></a>";
                    }
                    ?>
                </ul>
            </div>
        </div>
    </div>
</section>
<!-- end products -->