<?php
if (isset($_SESSION['client_id'])) {
    echo '<script>
            window.location.href = "index.php?p=profile";
          </script>';
}
?>
<!-- ======= Hero Section ======= -->
<section class="bg-bread">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1 class="" name="create_user">Create User</h1>
                <h4 class=""> <span name="home">Home</span> / <span name="create_user">Create User</span></h4>
            </div>
        </div>
    </div>
</section>
<!-- End Hero Section -->
    
<!--Create User Section-->
<section class="position-relative">
    
    <div class="container">
        <div class="row d-flex justify-content-center text-center">
            <div class="col-md-8">
                <form action="#" method="post" role="form">
                    <div class="row gy-4 d-flex justify-content-center">
                        <div class="col-md-8">
                            <h3 class="section-title mb-4" name="create_user">Create User</h3>
                            <p name="create_user_text">
                                To create an account, please complete the required fields in the form below. This will allow you to access all our features, manage your orders, and stay updated with the latest offerings.
                            </p>
                        </div>
                        <div class="col-lg-6 form-group">
                            <input type="text" name="first_name" id="first-name" class="form-control" placeholder="First Name" required>
                        </div>
                        <div class="col-lg-6 form-group">
                            <input type="text" name="last_name" id="last-name" class="form-control" placeholder="Last Name" required>
                        </div>
                        <div class="col-lg-6 form-group">
                            <input type="email" name="your_email" id="email" class="form-control" placeholder="Email" required>
                        </div>
                        <div class="col-lg-6 form-group position-relative">
                            <input type="password" id="password" name="your_password" class="form-control" placeholder="Password" required>
                            <button class="showBtn" type="button" id="show-password">
                                <i class="fa fa-eye-slash"></i>
                            </button>
                        </div>
                        <div class="col-lg-6 form-group">
                            <input type="number" name="your_phone" id="phone" class="form-control" placeholder="Phone" required>
                        </div>
                        <div class="col-lg-6 form-group">
                            <input type="text" name="your_address" id="address" class="form-control" placeholder="Address" required>
                        </div>
                        <div class="m-0">
                            <p id="msg-box" name="msg-box" class="m-0 mt-2"></p>
                        </div>
                        <div class="col-md-12">
                            <button class="shopBtn my-2" type="button" name="create" id="registerBtn">Create</button>
                            <p>
                                <span name="already_have_account">Already have an account? </span> <a href="index.php?p=login" class="extralink"  name="login_here"> Login Here</a>
                            </p>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>

<script>
    document.getElementById('show-password').addEventListener('click', function() {
        var passwordInput = document.getElementById('password');
        var eyeIcon = this.querySelector('i');

        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            eyeIcon.classList.remove('fa-eye-slash');
            eyeIcon.classList.add('fa-eye');
        } else {
            passwordInput.type = 'password';
            eyeIcon.classList.remove('fa-eye');
            eyeIcon.classList.add('fa-eye-slash');
        }
    });
</script>

<script>
/*-------------------------------------------
            Create User Form
-------------------------------------------*/ 

$(document).ready(function () {
    if ($('#registerBtn').length) {
        $('#registerBtn').on('click', function (event) {
            event.preventDefault();

            let firstName = $('#first-name').val().trim();
            let lastName = $('#last-name').val().trim();
            let email = $('#email').val().trim();
            let password = $('#password').val().trim();
            let phone = $('#phone').val().trim();
            let address = $('#address').val().trim();

            if (firstName.length < 3) {
                $('#msg-box').html(
                    language === 'arabic'
                        ? 'يجب أن يتكون الاسم الأول من 3 أحرف على الأقل.'
                        : 'First name should be at least 3 characters long.'
                );
                return;
            }

            if (lastName.length < 3) {
                $('#msg-box').html(
                    language === 'arabic'
                        ? 'يجب أن يتكون الاسم الأخير من 3 أحرف على الأقل.'
                        : 'Last name should be at least 3 characters long.'
                );
                return;
            }

            const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (!emailPattern.test(email)) {
                $('#msg-box').html(
                    language === 'arabic'
                        ? 'يرجى إدخال عنوان بريد إلكتروني صالح.'
                        : 'Please enter a valid email address.'
                );
                return;
            }

            if (password.length < 6) {
                $('#msg-box').html(
                    language === 'arabic'
                        ? 'يجب أن تكون كلمة المرور مكونة من 6 أحرف على الأقل.'
                        : 'Password should be at least 6 characters long.'
                );
                return;
            }

            const phonePattern = /^[0-9]{6,}$/;
            if (!phonePattern.test(phone)) {
                $('#msg-box').html(
                    language === 'arabic'
                        ? 'يجب أن يحتوي رقم الهاتف على أرقام فقط ويتكون من 6 أحرف على الأقل.'
                        : 'Phone number should contain only digits and be at least 6 characters long.'
                );
                return;
            }

            if (address === '') {
                $('#msg-box').html(
                    language === 'arabic'
                        ? 'لا يمكن أن يكون العنوان فارغًا.'
                        : 'Address cannot be empty.'
                );
                return;
            }

            $('#msg-box').html(language === 'arabic' ? 'يرجى الانتظار...' : 'Please Wait...');

            let urlReg = '<?php echo $path_api; ?>client/register.php';

            let postData = JSON.stringify({
                first_name: firstName,
                last_name: lastName,
                email: email,
                password: password,
                phone_number: phone,
                address: address
            });

            console.log('urlReg: ' + urlReg);

            $.ajax({
                url: urlReg,
                type: 'POST',
                data: postData,
                contentType: 'application/json',
                success: function (response) {
                    console.log(response);
                    $('#msg-box').html(response.message);

                    if (response.success) {
                        window.location.href = 'index.php?p=login';
                    }
                },
                error: function (xhr, status, error) {
                    $('#msg-box').html(
                        language === 'arabic'
                            ? 'حدث خطأ. يرجى المحاولة مرة أخرى لاحقًا.'
                            : 'An error occurred. Please try again later.'
                    );
                }
            });
        });
    }
});

</script>
