<?php
if (!isset($_SESSION['client_id'])) {
    // header("Location: index.php?p=login");
    echo '<script>
            window.location.href = "index.php?p=login";
          </script>';
    exit;
} else {
    $client_id = $_SESSION['client_id'];
}
?>

<!-- ======= Hero Section ======= -->
<section class="bg-bread">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1 class="" name="my_orders">My Orders</h1>
                <h4 class=""><span name="home">Home</span> / <span name="my_orders">My Orders</span></h4>
                <!--<a href="#" class="blue-qinnBtn">Select Your Saftey Box</a>-->
            </div>
        </div>
    </div>
</section>
<!-- ======= End Hero Section ======= -->

<!--Orders Start-->
<section>
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h3 class="section-title mb-4" name="my_orders">My Orders</h3>
                <p name="my_orders_text">
                    Easily access and review your past orders, view detailed invoices, and track the current status of each order.
                </p>
            </div>
        </div>

        <div class="row">
            <table class="table">
                
                <thead>
                    <tr>
                        <th scope="col" name="id">ID</th>
                        <th scope="col" name="date">Date</th>
                        <th scope="col" name="total">Total</th>
                        <th scope="col" name="status">Status</th>
                        <th scope="col" name="view">View</th>
                    </tr>
                </thead>
                
                <tbody id="orders-container">
                    
                </tbody>
                
            </table>

        </div>
    </div>
</section>
<style>
    .table thead th {
        background-color: var(--teal);
        border-color: var(--teal);
        color: #fefefe;
    }
    .table td, .table th{
        color: var(--teal);
        background: transparent;
        border: none;
    }
</style>

<script>

$(document).ready(function() {
    let urlHistory = '<?php echo $path_api; ?>client/history.php';
    let client_id = '<?php echo $client_id; ?>';
    
    // console.log("urlHistory: " + urlHistory);
    // console.log("client_id: " + client_id);

    $.ajax({
        url: urlHistory,
        type: 'POST',
        dataType: 'json',
        data: JSON.stringify({
            client_id: client_id
        }),
        contentType: 'application/json',
        success: function(response) {
            const $orderContainer = $('#orders-container');
            $orderContainer.empty();
            let tableHTML = '';
            // console.log(response);
            if (response.success) {
                $.each(response.orders, function(index, order) {
                    tableHTML += `
                        <tr>
                            <td scope="row">${order.order_id}</td>
                            <td>${order.date_of_order}</td>
                            <td><?php echo $currency; ?> ${order.total}</td>
                            <td>${order.status}</td>
                            <td><a href="${response.invoice_url}${order.order_id}" target="_blank" name="invoice">Invoice</a></td>
                        </tr>
                    `;
                });

                $orderContainer.html(tableHTML);
            } else {
                console.log(response.message);
            }
        },
        error: function(xhr, status, error) {
            $('#msg-box').html('An error occurred. Please try again later.');
        }
    });
});

</script>
