<?php
ini_set('display_errors', 1);
include_once "./connect.php";
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Credentials: true");
header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

$database_connect = new database_connect();

// $query = "SELECT title, description, image FROM sections WHERE status = 1"; 


if (isset($_GET['language'])) {
    $language = $database_connect->sanitize($_GET['language']);
} else {
    $language = 'english';
}

// echo $language;

if ($language !== 'english') {
    $query = "
        SELECT 
            sections.id, 
            sections.image, 
            sections.date_created, 
            section_translation.title AS title, 
            section_translation.description AS description 
        FROM 
            sections
        JOIN 
            section_translation ON sections.id = section_translation.section_id
        JOIN 
            languages ON section_translation.language_id = languages.id
        WHERE 
            sections.status = 1 AND languages.name = '$language'
    ";
} else {
    // Query for the 'sections' table ONLY
    $query = "SELECT * FROM sections WHERE status = 1 ";
}

if (isset($_POST['id'])) {
    $id = intval($_POST['id']);
    // $query .= " AND id = $id"; 
    $query .= " AND sections.id = $id"; 
}

$result = $database_connect->get_results($query);

$response = array();

if ($result) {
    $html = '';
    $row = $result[0]; // Fetch the first result only
    $banner_img = $path_img . $row['image'];

    // Generate the HTML
    $html = "<section class=\"bg-banner\" style=\"background: url('{$banner_img}') center no-repeat\">
        <div class=\"container\">
            <div class=\"row justify-content-center\">
                <div class=\"col-md-8 text-center\">
                    <h1 class=\"text-white text-uppercase\">{$row['title']}</h1>
                    <p>{$row['description']}</p>
                    <a href=\"index.php?p=products\" class=\"shopBtn\">Shop</a>
                </div>
            </div>
        </div>
    </section>";

    // Add success, HTML, title, description, and image to the response for now
    $response['success'] = true;
    $response['html'] = $html;
    $response['title'] = $row['title'];
    $response['description'] = $row['description'];
    // $response['date_created'] = $row['date_created'];
    $response['image'] = $row['image'];

} else {
    $response['success'] = false;
    $response['message'] = 'No items found';
}

echo json_encode($response);
?>
