<?php 
ini_set('display_errors', 1);
include_once "../connect.php";
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Credentials: true");
header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

$database_connect = new database_connect();

// Decode JSON input
$data = json_decode(file_get_contents("php://input"), true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Sanitize inputs
    function sanitize($input) {
        global $database_connect;
        $input = trim($input); // Remove whitespace
        $input = stripslashes($input); // Remove backslashes
        $input = htmlspecialchars($input, ENT_QUOTES, 'UTF-8'); // Convert special characters
        $input = mysqli_real_escape_string($database_connect->conn, $input); // Escape for SQL
        return $input;
    }

    // Check if the required fields are set and not empty
    if (isset($data['first_name'], $data['last_name'], $data['email'], $data['password']) && 
        !empty($data['first_name']) && !empty($data['last_name']) && 
        !empty($data['email']) && !empty($data['password'])) {
        
        $first_name = sanitize($data['first_name']);
        $last_name = sanitize($data['last_name']);
        $email = sanitize($data['email']);
        $password = sanitize($data['password']);
        $phone_number = isset($data['phone_number']) ? sanitize($data['phone_number']) : '';
        $address = isset($data['address']) ? sanitize($data['address']) : '';
        $date_created = date('Y-m-d');  // Proper date format for SQL
        $status = 1;

        // Check if the email already exists
        $email_check_query = "SELECT COUNT(*) as email_count FROM client WHERE email = '$email'";
        $email_check_result = $database_connect->execute($email_check_query);
        $email_check_data = mysqli_fetch_assoc($email_check_result);

        if ($email_check_data['email_count'] > 0) {
            // Email already exists
            $response['success'] = false;
            $response['message'] = 'Email already exists, please use a different email';
        } else {
            // SQL query to insert the new client
            $insert_query = "INSERT INTO client (first_name, last_name, email, password, phone_number, 
                             address, date_created, status) 
                             VALUES ('$first_name', '$last_name', '$email', '$password', 
                             '$phone_number', '$address', '$date_created', $status)";

            $insert_result = $database_connect->execute($insert_query);

            if ($insert_result) {
                $response['success'] = true;
                $response['message'] = 'Successfully registered';
            } else {
                $response['success'] = false;
                $response['message'] = 'Error please try again.';
            }
        }
    } else {
        // Missing required fields
        $response['success'] = false;
        $response['message'] = 'Missing required fields';
    }

    // Return the JSON response
    echo json_encode($response);
}

?>
