<?php
ini_set('display_errors', 1);
// error_reporting(E_ALL);
include_once "./connect.php";
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Credentials: true");
header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

$database_connect = new database_connect();
$conn = $database_connect->conn;
$data = json_decode(file_get_contents("php://input"), true);

$response = [];

$order_id = isset($data['order_id']) ? $data['order_id'] : null;

if ($order_id) {
    
    // Fetch client_id and other order-related details    
    $orderQuery = "
        SELECT client_id, guest_name, guest_phone_number, guest_email, guest_address, date_created, discount 
        FROM orders
        WHERE id = '$order_id'
    ";
    $orderResult = $conn->query($orderQuery);

    if ($orderResult->num_rows > 0) {
        $orderData = $orderResult->fetch_assoc();
        $client_id = $orderData['client_id'];

        if ($client_id == 0) {
            $client = [
                'name' => $orderData['guest_name'],
                'phone_number' => $orderData['guest_phone_number'],
                'email' => $orderData['guest_email'],
                'address' => $orderData['guest_address']
            ];
        } else {
            $clientQuery = "
                SELECT CONCAT(first_name, ' ', last_name) AS name, phone_number, email, address 
                FROM client 
                WHERE id = '$client_id'
            ";
            $clientResult = $conn->query($clientQuery);

            if ($clientResult->num_rows > 0) {
                $client = $clientResult->fetch_assoc();
            } else {
                $client = [
                    'name' => null,
                    'phone_number' => null,
                    'email' => null,
                    'address' => null
                ];
            }
        }
        
        // Fetch item details for the order
        $detailsQuery = "
            SELECT od.item_id, od.price, od.quantity, od.discount, i.name as item_name 
            FROM orders_details od
            INNER JOIN item i ON i.id = od.item_id
            WHERE od.order_id = '$order_id'
        ";
        
        $detailsResult = $conn->query($detailsQuery);

        if ($detailsResult->num_rows > 0) {
            $items = [];
            $orderTotal = 0;

            while ($detail = $detailsResult->fetch_assoc()) {
                $item_id = $detail['item_id'];
                $price_per_item = $detail['price'];
                $quantity = $detail['quantity'];
                $item_discount = $detail['discount'];
                $item_name = $detail['item_name'];

                // Calculate discounted price
                $discounted_price_per_item = $price_per_item - ($price_per_item * $item_discount / 100);
                $total_price = $discounted_price_per_item * $quantity;
                $orderTotal += $total_price;

                $items[] = [
                    'item_id' => $item_id,
                    'item_name' => $item_name,
                    'price_per_item' => $price_per_item,
                    'discounted_price_per_item' => $discounted_price_per_item,
                    'quantity' => $quantity,
                    'item_discount' => $item_discount,
                    'total_price' => $total_price
                ];
            }

            // Add the coupon discount to the final order total
            $coupon_discount = $orderData['discount'];
            $orderTotalAfterCoupon = $orderTotal - ($orderTotal * $coupon_discount / 100);

            $response['success'] = true;
            $response['message'] = "Invoice details retrieved successfully";
            $response['client'] = $client;
            $response['items'] = $items;
            $response['order_total'] = $orderTotal;
            $response['order_total_after_coupon'] = $orderTotalAfterCoupon;
            $response['coupon_discount'] = $coupon_discount;
            $response['date_order'] = $orderData['date_created'];
        } else {
            $response['success'] = false;
            $response['message'] = "No order details found for the provided order id";
        }
    } else {
        $response['success'] = false;
        $response['message'] = "Order not found for the provided order id";
    }

    $conn->close();
} else {
    $response['success'] = false;
    $response['message'] = "Please provide an order id";
}

echo json_encode($response);
?>
