<?php
ini_set('display_errors', 1);
include_once './connect.php';

header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Credentials: true");
header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

$database_connect = new database_connect();
$conn = $database_connect->conn;

$data = json_decode(file_get_contents("php://input"), true);

$response = ["success" => false, "message" => "Invalid request."];

if (isset($data["news_email"])) {
    $email = filter_var($data["news_email"], FILTER_SANITIZE_EMAIL);

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $response["message"] = "Invalid email address, please enter a valid email.";
    } else {
        $email = mysqli_real_escape_string($conn, $email);

        $checkEmailQuery = "SELECT * FROM `subscribe` WHERE `email` = '$email'";
        // $result = $conn->query($checkEmailQuery);
        $result = $database_connect->get_results($checkEmailQuery);

        if ($result) {
            $response["message"] = "Email address already exists, please use a different email.";
        } else {
            $date_created = date("Y-m-d H:i:s");
            $insertQuery = "INSERT INTO `subscribe` (`email`, `date_created`) VALUES ('$email', '$date_created')";

            if ($conn->query($insertQuery) === TRUE) {
                $response = ["success" => true, "message" => "Successfully subscribed to our newsletter"];
            } else {
                $response["message"] = "We encountered an error while registering your email, please try again.";
            }
        }
    }
}

echo json_encode($response);
exit;
?>
