<?php
include_once "../connect.php";
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Credentials: true");
header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');
$database_connect = new database_connect();

if (isset($_GET['language'])) {
    $language = $database_connect->sanitize($_GET['language']);
} else {
    $language = 'english';
}

if ($language !== 'english') {
    $query = "
        SELECT 
            category.id, 
            category.image, 
            category.position, 
            category.parent_id, 
            category.date_created, 
            category_translation.name AS name 
        FROM 
            category
        JOIN 
            category_translation ON category.id = category_translation.category_id
        JOIN 
            languages ON category_translation.language_id = languages.id
        WHERE 
            category.status = 1 AND languages.name = '$language'
    ";
} else {
    // Query for the 'category' table ONLY
    $query = "SELECT * FROM category WHERE status = 1 ";
}



// Check if GET parameters are set and append conditions to the query
if (isset($_GET['id'])) {
    $id = $_GET['id'];
    $query .= " AND id = $id"; 
}

if (isset($_GET['name'])) {
    $name = $_GET['name'];
    $query .= " AND name LIKE '%$name%'"; // Use LIKE for partial name matches
}

if (isset($_GET['parent_id'])) {
    $parent_id = $_GET['parent_id'];
    $query .= " AND parent_id = $parent_id"; // Filter by parent category
}

if (isset($_GET['user_id'])) {
    $user_id = $_GET['user_id'];
    $query .= " AND user_id = $user_id"; // Filter by user ID
}

// $limit = isset($_GET['limit']) ? intval($_GET['limit']) : 999;

// $query .= " LIMIT $limit";

// Execute the query
$result = $database_connect->get_results($query);

// Prepare the response array
$response = array();

if ($result) {
    $objects = array(); 

    foreach ($result as $row) {
        $object = array(); 
        $object['id'] = $row['id'];
        $object['name'] = $row['name'];
        $object['image'] = $path_img . $row['image'];
        $object['status'] = $row['status'];
        $object['date_created'] = $row['date_created'];
        $object['parent_id'] = $row['parent_id'];
        $object['user_id'] = $row['user_id'];

        // Add each object to the result array
        array_push($objects, $object);
    }

    $response['success'] = true;
    $response['objects'] = $objects;

} else {
    $response['success'] = false;
    $response['message'] = 'No categories found';
    $response['objects'] = array();
}

// Return the JSON-encoded response
echo json_encode($response);
?>
