<?php
ini_set('display_errors', 1);
include_once '../mailer/php_mailer.php';
include_once "../../connect.php";
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Credentials: true");
header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

$database_connect = new database_connect();

// Decode JSON input
$data = json_decode(file_get_contents("php://input"), true);

$response = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($data['forget_email'])) {
        $forget_email = $data['forget_email'];

        $forget_email = mysqli_real_escape_string($database_connect->conn, $forget_email);

        // Check if the email exists in the database
        $query = "SELECT id FROM client WHERE email = '$forget_email'";
        $result = $database_connect->get_results($query);

        if ($result) {
            // Email exists
            // Generate a 6-digit code for password reset
            $reset_code = rand(100000, 999999);

            // Update the client table with the reset code
            $client_id = $result[0]['id'];
            $update_query = "UPDATE client SET reset_code = '$reset_code' WHERE id = $client_id";
            $update_result = $database_connect->execute($update_query);

            if ($update_result) {
                // Send the reset code via PHPMailer
                $php_mailer = new php_mailer();
                $res_email = $php_mailer->send_verification_code($forget_email, $reset_code);

                if ($res_email) {
                    $response['success'] = true;
                    $response['message'] = 'Reset code generated, saved, and sent via email successfully.';
                    $response['reset_code'] = $reset_code;
                } else {
                    $response['success'] = false;
                    $response['message'] = 'Failed to send reset code via email.';
                }
            } else {
                $response['success'] = false;
                $response['message'] = 'Error updating reset code in the database.';
            }
        } else {
            // Email does not exist
            $response['success'] = false;
            $response['message'] = 'Email not found in the database.';
        }
    } else {
        // Required fields are missing
        $response['success'] = false;
        $response['message'] = 'Missing required fields.';
    }

    echo json_encode($response);
}
?>
