<?php
ini_set('display_errors', 1);
// error_reporting(E_ALL);
include_once "../../connect.php";
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Credentials: true");
header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

$database_connect = new database_connect();
$conn = $database_connect->conn;
$data = json_decode(file_get_contents("php://input"), true);

$response = [];

$client_id = isset($data['client_id']) ? $data['client_id'] : null;

if ($client_id) {
    $orderQuery = "SELECT o.id, o.date_created, os.title AS status_title, o.discount AS order_discount 
                   FROM orders o 
                   LEFT JOIN orders_status os ON o.order_status_id = os.id 
                   WHERE o.client_id = '$client_id'";
                   
    $orderResult = $conn->query($orderQuery);

    if ($orderResult->num_rows > 0) {
        $orders = [];
        
        // Loop through each order found
        while ($order = $orderResult->fetch_assoc()) {
            $order_id = $order['id'];
            $date_of_order = $order['date_created'];
            $status_title = $order['status_title'];
            $order_discount = $order['order_discount']; // Order discount in %

            $detailsQuery = "SELECT price, quantity, discount AS item_discount 
                             FROM orders_details 
                             WHERE order_id = '$order_id'";
                             
            $detailsResult = $conn->query($detailsQuery);

            $subtotal = 0;
            if ($detailsResult->num_rows > 0) {
                while ($detail = $detailsResult->fetch_assoc()) {
                    // Calculate subtotal for each item considering the item discount
                    $price = $detail['price'];
                    $quantity = $detail['quantity'];
                    $item_discount = $detail['item_discount']; // Item discount in %

                    // Apply the discount percentage to the price
                    $price_after_discount = $price * (1 - $item_discount / 100);
                    $subtotal += $price_after_discount * $quantity;
                }
            }

            // Apply the order discount as a percentage of the subtotal
            $total = $subtotal * (1 - $order_discount / 100);

            $orders[] = [
                'order_id' => $order_id,
                'date_of_order' => $date_of_order,
                'subtotal' => $subtotal,
                'order_discount' => $order_discount,
                'total' => $total,
                'status' => $status_title
            ];
        }

        // Prepare the response
        $response['success'] = true;
        $response['message'] = "Order items retrieved successfully";
        $response['orders'] = $orders;
        $response['invoice_url'] = 'https://blackmoonclothing.com/invoice/invoice.php?order_id=';
    } else {
        $response['success'] = false;
        $response['message'] = "No orders found for the provided client_id";
    }

    $conn->close();
} else {
    $response['success'] = false;
    $response['message'] = "Please provide a client_id";
}

echo json_encode($response);
?>
