<?php
ini_set('display_errors', 1);
include_once "../connect.php";
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Credentials: true");
header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

$database_connect = new database_connect();
$conn = $database_connect->conn;

// Decode JSON input
$data = json_decode(file_get_contents("php://input"), true);

$response = [];


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($data['language'])) {
        $language = $data['language'];
        
        if (!$language) {
            $response['success'] = false;
            $response['message'] = 'Invalid language specified.';
            echo json_encode($response);
            exit;
        }
        
        $query = "SELECT name, $language AS translation FROM dictionary";
        $result = $conn->query($query);

        if ($result->num_rows > 0) {
            $response['success'] = true;
            $response['dictionary'] = [];
            
            while ($row = $result->fetch_assoc()) {
                $response['dictionary'][$row['name']] = $row['translation'];
            }
        } else {
            $response['success'] = false;
            $response['message'] = 'No translations found.';
        }
        
    } else {
        // Required fields are missing
        $response['success'] = false;
        $response['message'] = 'Missing required fields.';
    }

    echo json_encode($response);
}
?>
