<?php
ini_set('display_errors', 1);
include_once "../connect.php";
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Credentials: true");
header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

$database_connect = new database_connect();

if (isset($_GET['language'])) {
    $language = $database_connect->sanitize($_GET['language']);
} else {
    $language = 'english';
}

if ($language !== 'english') {
    $query = "
        SELECT 
            item.id, 
            item.price, 
            item.image, 
            item.discount, 
            item.quantity, 
            item.date_created, 
            item.brand_id, 
            item.is_trending, 
            item.is_new, 
            item.out_of_stock, 
            item.category_id, 
            item.total_reviews, 
            item_translation.name AS name, 
            item_translation.description AS description 
        FROM 
            item
        JOIN 
            item_translation ON item.id = item_translation.item_id
        JOIN 
            languages ON item_translation.language_id = languages.id
        WHERE 
            item.status = 1 AND languages.name = '$language'
    ";
} else {
    $query = "SELECT * FROM item WHERE status = 1";
    // $query = "SELECT * FROM item LEFT JOIN item_translation ON item.id = item_translation.item_id WHERE status = 1";
}

$count_query = "SELECT COUNT(*) as total FROM item WHERE status = 1";

// Check and append filters to the query
if (isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $query .= " AND item.id = $id"; 
    $count_query .= " AND item.id = $id"; 
}
if (isset($_GET['name'])) {
    $name = $database_connect->sanitize($_GET['name']);
    $query .= " AND item.name LIKE '%$name%'"; 
    $count_query .= " AND item.name LIKE '%$name%'";
}
if (isset($_GET['category_id'])) {
    $category_ids = array_map('intval', explode(',', $_GET['category_id']));
    $category_ids_string = implode(',', $category_ids);
    $query .= " AND item.category_id IN ($category_ids_string)";
    $count_query .= " AND item.category_id IN ($category_ids_string)";
}
if (isset($_GET['brand_id'])) {
    $brand_id = intval($_GET['brand_id']);
    $query .= " AND item.brand_id = $brand_id";
    $count_query .= " AND item.brand_id = $brand_id"; 
}
if (isset($_GET['is_trending'])) {
    $is_trending = intval($_GET['is_trending']);
    $query .= " AND item.is_trending = $is_trending";
    $count_query .= " AND item.is_trending = $is_trending";
}
if (isset($_GET['search_term'])) {
    $search_term = $database_connect->sanitize($_GET['search_term']);
    $query .= " AND item.name LIKE '%$search_term%'";
    $count_query .= " AND item.name LIKE '%$search_term%'";
}
// if (isset($_GET['search_term'])) {
//     $search_term = $database_connect->sanitize($_GET['search_term']);
//     $query .= " AND (item.name LIKE '%$search_term%' OR item_translation.name LIKE '%$search_term%')";
//     $count_query .= " AND (item.name LIKE '%$search_term%' OR item_translation.name LIKE '%$search_term%')";
// }

if (isset($_GET['discount']) && $_GET['discount'] == 1) {
    $query .= " AND item.discount <> 0";
    $count_query .= " AND item.discount <> 0";
}

// Handle sorting (only one ORDER BY here)
$order_clause = "";
if (isset($_GET['sort_price'])) {
    $sort_price = $_GET['sort_price'];
    if ($sort_price === 'price_asc') {
        // $order_clause = " ORDER BY item.price ASC";
        $order_clause = " ORDER BY item.price * (1 - item.discount / 100) ASC";
    } elseif ($sort_price === 'price_desc') {
        // $order_clause = " ORDER BY item.price DESC";
        $order_clause = " ORDER BY item.price * (1 - item.discount / 100) DESC";
    }
} elseif (isset($_GET['sort_date'])) {
    $sort_date = $_GET['sort_date'];
    if ($sort_date === 'date_asc') {
        $order_clause = " ORDER BY item.date_created ASC";
    } elseif ($sort_date === 'date_desc') {
        $order_clause = " ORDER BY item.date_created DESC";
    }
}
$query .= $order_clause;

// Set pagination
$limit = isset($_GET['limit']) ? intval($_GET['limit']) : 12;
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$offset = ($page - 1) * $limit;

$query .= " LIMIT $limit OFFSET $offset";

// echo $query;

$result = $database_connect->get_results($query);

$result_count = $database_connect->get_results($count_query);
$total_items = $result_count[0]['total'];
$total_pages = ceil($total_items / $limit);

$response = array();

if ($result) {
    $objects = array(); 

    foreach ($result as $row) {
        $object = $row; 
        $id = $row["id"];
        
        // Calculate discount price if discount is not 0 in the DB field
        if ($row['discount'] != 0) {
            // Formula to calculate discoutned price, *Noe*
            $discounted_price = $row['price'] - ($row['price'] * ($row['discount'] / 100));
            $object['price_discount'] = round($discounted_price, 2);
        } else {
            $object['price_discount'] = null;
        }
    
        // Full Image Path
        // $object['image'] = $path_img . $row['image'];

        // Get sizes
        $query_item_size = "SELECT size.id, size.name, item_size.price, item_size.discount, item_size.out_of_stock FROM item_size, size WHERE item_size.status = 1 AND item_size.size_id = size.id AND item_size.item_id = $id";
        if (isset($_GET['size_id'])) {
            $size_id = intval($_GET['size_id']);
            $query_item_size .= " AND item_size.size_id = $size_id"; 
            // echo $query_item_size;
        }
        $result_item_size = $database_connect->get_results($query_item_size);
        $sizes = array(); 
        if ($result_item_size) {
            foreach ($result_item_size as $row_item_size) {
                $sizes[] = $row_item_size; 
            }
        }
        $object['size'] = $sizes;

        // Get colors
        $query_item_color = "SELECT color.id, color.name, item_color.out_of_stock FROM item_color, color WHERE item_color.status = 1 AND item_color.color_id = color.id AND item_color.item_id = $id";
        if (isset($_GET['color_id'])) {
            $color_id = intval($_GET['color_id']);
            $query_item_color .= " AND item_color.color_id = $color_id"; 
            // echo $query_item_color;
        }
        $result_item_color = $database_connect->get_results($query_item_color);
        $colors = array(); 
        if ($result_item_color) {
            foreach ($result_item_color as $row_item_color) {
                $colors[] = $row_item_color; 
            }
        }
        $object['color'] = $colors;

        // Get lengths
        $query_item_length = "SELECT length.id, length.name FROM item_length, length WHERE item_length.status = 1 AND item_length.length_id = length.id AND item_length.item_id = $id";
        $result_item_length = $database_connect->get_results($query_item_length);
        $length = array(); 
        if ($result_item_length) {
            foreach ($result_item_length as $row_item_length) {
                $length[] = $row_item_length; 
            }
        }
        $object['length'] = $length;

        // Get weights
        $query_item_weight = "SELECT weight.id, weight.name FROM item_weight, weight WHERE item_weight.status = 1 AND item_weight.weight_id = weight.id AND item_weight.item_id = $id";
        $result_item_weight = $database_connect->get_results($query_item_weight);
        $weight = array(); 
        if ($result_item_weight) {
            foreach ($result_item_weight as $row_item_weight) {
                $weight[] = $row_item_weight; 
            }
        }
        $object['weight'] = $weight;
        
        
        // Fetch additional images for the item to JSON         ++++    ----∨∨∨∨
        // $query_item_images = "SELECT image FROM item_images WHERE status = 1 AND item_id = $id";
        // $result_item_images = $database_connect->get_results($query_item_images);
        // $additional_images = array();

        // if ($result_item_images) {
        //     foreach ($result_item_images as $row_image) {
        //         $additional_images[] = $path_img . $row_image['image'];
        //     }
        // }

        // // "image" is now JSON
        // $object['image'] = json_encode(array_merge([$object['image']], $additional_images));
        // Comment From Here UP if you need one image           ++++    ----^^^^
        
        
        // Fetch additional images for the item                 ++++    ----∨∨∨∨
        // $query_item_images = "SELECT image FROM item_images WHERE status = 1 AND item_id = $id";
        // $result_item_images = $database_connect->get_results($query_item_images);
        // $images = array();

        // if ($result_item_images) {
        //     foreach ($result_item_images as $row_image) {
        //         $images[] = $path_img . $row_image['image'];
        //     }
        // }
        // Comment From Here UP if you don't need object images ++++    ----^^^^

        // $object['images'] = $images;
        
## ----                 Sending images as array of object                ---- ##

        // Full primary image path
        $primary_image = $path_img . $row['image'];

        // Fetch additional images for the item with indexed objects
        $query_item_images = "SELECT image FROM item_images WHERE status = 1 AND item_id = $id";
        $result_item_images = $database_connect->get_results($query_item_images);

        $images = array();
        $index = 0;

        // Add primary image as the first item in the array with an explicit index key
        $images["$index"] = $primary_image;
        $index++;

        // Add additional images, each with its explicit index as the key
        if ($result_item_images) {
            foreach ($result_item_images as $row_image) {
                $images["$index"] = $path_img . $row_image['image'];
                $index++;
            }
        }

        // Set the $object['image'] to the associative array of indexed image paths
        $object['image'] = $images;

            $objects[] = $object;
        }

    $response['success'] = true;
    $response['objects'] = $objects;
    $response['total_pages'] = $total_pages;
    $response['current_page'] = $page;
    $response['limit'] = $limit;

} else {
    $response['success'] = false;
    $response['message'] = 'No items found';
    $response['objects'] = array();
}

echo json_encode($response);
?>
