<?php
define('DB_HOST', "localhost");      
define('DB_USER', 'amcserver_user');
define('DB_PASS', 'tag.amc.2013');   
define('DB_NAME', 'amcserver_amcapp');

class database_connect {
    private $conn;

    public function __construct() {
        // Connect to the database
        $this->conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

        // Set to utf8 encoding
        $this->conn->set_charset("utf8");

        // Handle connection error
        if ($this->conn->connect_error) {
            die('Connection failed: ' . $this->conn->connect_error);
        }
    }

    // Execute a query (for SELECT, INSERT, UPDATE, DELETE)
    public function execute($query) {
        if ($this->conn->query($query) === TRUE) {
            return true; // Return true if successful
        } else {
            return 'Error: ' . $this->conn->error; // Return error message
        }
    }

    // Get last inserted ID
    public function last_id_insert() {
        return $this->conn->insert_id;
    }

    // Retrieve results from a SELECT query
    public function get_results($query) {
        $rows = array();
        $result = $this->conn->query($query);

        if ($result) {
            while ($row = $result->fetch_assoc()) {
                $rows[] = $row; // Fetch associative array
            }
            $result->free(); // Free the result set
        } else {
            return 'Error: ' . $this->conn->error; // Return error message if query fails
        }

        return $rows; // Return results as an array
    }

    // Prepare a statement for secure execution
    public function prepare($query) {
        return $this->conn->prepare($query);
    }

    // Close the database connection
    public function close() {
        $this->conn->close();
    }
}

// Example usage
/*
$database = new database_connect();
$query = "SELECT * FROM item";
$results = $database->get_results($query);
print_r($results);
$database->close();
*/
?>
