<?php
ini_set('display_errors', 1);
include_once "connect.php";
include_once './mailer/php_mailer.php';
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Credentials: true");
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

$database_connect = new database_connect();
$conn = $database_connect->conn;

$data = json_decode(file_get_contents("php://input"), true);

$response = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Read order info
    $client_id = isset($data['order_info']['client_id']) ? intval($data['order_info']['client_id']) : 0;
    
    if ($client_id == 0) {
        $first_name = mysqli_real_escape_string($conn, trim($data['order_info']['first_name']));
        $last_name = mysqli_real_escape_string($conn, trim($data['order_info']['last_name']));
        $guest_name = $first_name . ' ' . $last_name;
        $guest_email = mysqli_real_escape_string($conn, trim($data['order_info']['email']));
        $sendEmail = $guest_email;
        $guest_phone = mysqli_real_escape_string($conn, trim($data['order_info']['phone_number']));
        $guest_address = mysqli_real_escape_string($conn, trim($data['order_info']['address']));
    } else {
        // Set guest info to NULL if client_id is not 0
        $guest_name = $guest_email = $guest_phone = $guest_address = NULL;
    }

    $notes = isset($data['order_info']['notes']) ? mysqli_real_escape_string($conn, trim($data['order_info']['notes'])) : '';
    
    // Date created
    $date_created = date('Y-m-d H:i:s');

    // Insert into orders table
    $insert_order = "
        INSERT INTO orders (client_id, guest_name, guest_email, guest_phone_number, guest_address, date_created, discount, order_status_id, notes, description)
        VALUES ('$client_id', " . ($guest_name ? "'$guest_name'" : "NULL") . ", " . ($guest_email ? "'$guest_email'" : "NULL") . ", " . ($guest_phone ? "'$guest_phone'" : "NULL") . ", " . ($guest_address ? "'$guest_address'" : "NULL") . ", '$date_created', 0, 1, '$notes', NULL)
    ";

    if (mysqli_query($conn, $insert_order)) {
        // Get the ID of the inserted order
        $order_id = mysqli_insert_id($conn);
        
        // Read cart items
        $items = isset($data['items']) ? $data['items'] : [];

        // Insert into order_details table
        foreach ($items as $item) {
            $item_id = intval($item['item_id']);
            $quantity = intval($item['quantity']);
            
            // Get the price and discount from the item table
            $result = mysqli_query($conn, "SELECT price, discount FROM item WHERE id = $item_id");
            $item_data = mysqli_fetch_assoc($result);
            
            // Determine the price to use based on discount
            if (isset($item_data['discount']) && $item_data['discount'] > 0) {
                $discount = floatval($item_data['discount']);
                $price = $item_data['price'] - ($item_data['price'] * ($discount / 100));
            } else {
                $price = $item_data['price'];
            }
            
            $insert_order_details = "
                INSERT INTO orders_details (order_id, item_id, discount, quantity, price, color_id, size_id, length_id, weight_id)
                VALUES ('$order_id', '$item_id', 0, '$quantity', '$price', NULL, NULL, NULL, NULL)
            ";
            
            mysqli_query($conn, $insert_order_details);
        }

        // Set up email details
        $php_mailer = new php_mailer();
        $subject = "Order Notice";
        $body = "Thank you for your purchase<br>
        To view your invoice, please click on the following link: <a href='https://amcserver.com/web/online_shop/invoice/invoice.php?order_id=$order_id'>View Invoice</a><br>
        Should you have any questions or require further assistance, please don't hesitate to contact us. Our dedicated support team is here to help.<br><br>
        We appreciate your business and look forward to serving you again in the future.<br><br>
        Best regards,<br>
        Shop Team";

        $email_status = $php_mailer->sendMail($sendEmail, $subject, $body);

        if ($email_status) {
            echo json_encode(['success' => true, 'message' => 'Order placed successfully. Check your mail to confirm purchase!']);
        } else {
            echo json_encode(['success' => true, 'message' => 'Order placed successfully, but we encountered an issue sending a mail, please contact support to confirm purchase.']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to place the order']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
?>
