<?php
ini_set('display_errors', 1);
include_once "../connect.php";
include_once './mailer/php_mailer.php';
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Credentials: true");
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

$database_connect = new database_connect();
$conn = $database_connect->conn;

$data = json_decode(file_get_contents("php://input"), true);

$response = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($data['order_info']['email'], $data['order_info']['discount']) ||
        (isset($data['order_info']['client_id']) && $data['order_info']['client_id'] == 0 && (
            !isset($data['order_info']['first_name'], $data['order_info']['last_name'], $data['order_info']['phone_number'], $data['order_info']['address'])
        ))
    ) {
        echo json_encode(['success' => false, 'message' => 'Missing required fields']);
        exit;
    }

    $client_id = isset($data['order_info']['client_id']) ? intval($data['order_info']['client_id']) : 0;
    $discount = isset($data['order_info']['discount']) ? doubleval($data['order_info']['discount']) : 0;
    $sendEmailClient = mysqli_real_escape_string($conn, trim($data['order_info']['email']));

    if ($client_id == 0) {
        $first_name = mysqli_real_escape_string($conn, trim($data['order_info']['first_name']));
        $last_name = mysqli_real_escape_string($conn, trim($data['order_info']['last_name']));
        $guest_name = $first_name . ' ' . $last_name;
        $guest_email = mysqli_real_escape_string($conn, trim($data['order_info']['email']));
        $guest_phone = mysqli_real_escape_string($conn, trim($data['order_info']['phone_number']));
        $guest_address = mysqli_real_escape_string($conn, trim($data['order_info']['address']));
    } else {
        $guest_name = $guest_email = $guest_phone = $guest_address = NULL;
    }

    $notes = isset($data['order_info']['notes']) ? mysqli_real_escape_string($conn, trim($data['order_info']['notes'])) : '';
    $date_created = date('Y-m-d H:i:s');

    $insert_order = "
    INSERT INTO orders (
        client_id, guest_name, guest_email, guest_phone_number, guest_address, date_created, discount, order_status_id, notes, description
    ) VALUES (
        '$client_id',
        " . ($guest_name ? "'$guest_name'" : "NULL") . ",
        " . ($guest_email ? "'$guest_email'" : "NULL") . ",
        " . ($guest_phone ? "'$guest_phone'" : "NULL") . ",
        " . ($guest_address ? "'$guest_address'" : "NULL") . ",
        '$date_created',
        '$discount',
        1,
        '$notes',
        NULL
    )
    ";

    if (mysqli_query($conn, $insert_order)) {
        $order_id = mysqli_insert_id($conn);
        $items = isset($data['items']) ? $data['items'] : [];

        foreach ($items as $item) {
            $item_id = intval($item['item_id']);
            $size_id = isset($item['size_id']) ? intval($item['size_id']) : 0;
            $color_id = isset($item['color_id']) ? intval($item['color_id']) : 0;
            $quantity = intval($item['quantity']);

            if ($size_id > 0) {
                // Fetch price and discount from item_size
                $size_query = "SELECT price, discount FROM item_size WHERE item_id = $item_id AND id = $size_id";
                $size_result = mysqli_query($conn, $size_query);

                if (mysqli_num_rows($size_result) > 0) {
                    $size_data = mysqli_fetch_assoc($size_result);
                    $price = $size_data['price'];
                    $discount = $size_data['discount'];

                    // Fallback to item discount if size discount is null or 0
                    if (is_null($discount) || $discount == 0) {
                        $item_query = "SELECT discount FROM item WHERE id = $item_id";
                        $item_result = mysqli_query($conn, $item_query);
                        $item_data = mysqli_fetch_assoc($item_result);
                        $discount = $item_data['discount'];
                    }
                } else {
                    // Fall back to item table
                    $item_query = "SELECT price, discount FROM item WHERE id = $item_id";
                    $item_result = mysqli_query($conn, $item_query);
                    $item_data = mysqli_fetch_assoc($item_result);
                    $price = $item_data['price'];
                    $discount = $item_data['discount'];
                }
            } else {
                // Fetch price and discount from item table directly
                $item_query = "SELECT price, discount FROM item WHERE id = $item_id";
                $item_result = mysqli_query($conn, $item_query);
                $item_data = mysqli_fetch_assoc($item_result);
                $price = $item_data['price'];
                $discount = $item_data['discount'];
            }

            // Insert into order_details
            $insert_order_details = "
                INSERT INTO orders_details (
                    order_id, item_id, discount, quantity, price, color_id, size_id, length_id, weight_id
                ) VALUES (
                    '$order_id', '$item_id', '$discount', '$quantity', '$price',
                    " . ($color_id > 0 ? "'$color_id'" : "NULL") . ",
                    " . ($size_id > 0 ? "'$size_id'" : "NULL") . ",
                    NULL, NULL
                )
            ";

            mysqli_query($conn, $insert_order_details);
        }

        $php_mailer = new php_mailer();
        $subject_client = "Order Notice";
        $body_client = "Thank you for your purchase<br>
        To view your invoice, please click on the following link: <a href='https://lamassat-qatar.com/invoice/invoice.php?order_id=$order_id'>View Invoice</a><br>
        Should you have any questions or require further assistance, please don't hesitate to contact us. Our dedicated support team is here to help.<br><br>
        We appreciate your business and look forward to serving you again in the future.<br><br>
        Best regards,<br>
        lamassat Team";

        $email_client = $php_mailer->sendMail($sendEmailClient, $subject_client, $body_client);
        
        $sendEmailCompany = "info@lamassat-qatar.com";
        $subject_company = "Order Notifcation";
        $body_company = "An order has been placed with the following <a href='https://lamassat-qatar.com/invoice/invoice.php?order_id=$order_id'>invoice</a>";
        
        $email_company = $php_mailer->sendMail($sendEmailCompany, $subject_company, $body_company);

        if ($email_client) {
            echo json_encode(['success' => true, 'message' => 'Order placed successfully. Check your mail to confirm purchase!', 'order_id' => $order_id]);
        } else {
            echo json_encode(['success' => true, 'message' => 'Order placed successfully, but we encountered an issue sending a mail, please contact support to confirm purchase.', 'order_id' => $order_id]);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to place the order']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
?>
