<?php
ini_set('display_errors', 1);
include_once "../connect.php";
include_once './mailer/php_mailer.php';

header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Credentials: true");
header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

$database_connect = new database_connect();
$conn = $database_connect->conn;
$response = array();

// Get JSON input
$data = json_decode(file_get_contents("php://input"), true);

$name = isset($data['name']) ? mysqli_real_escape_string($conn, trim($data['name'])) : '';
$email = isset($data['email']) ? mysqli_real_escape_string($conn, trim($data['email'])) : '';
$phone = isset($data['phone']) ? mysqli_real_escape_string($conn, trim($data['phone'])) : '';
$subject = isset($data['subject']) ? mysqli_real_escape_string($conn, trim($data['subject'])) : '';
// $message = isset($data['message']) ? mysqli_real_escape_string($conn, trim($data['message'])) : '';
$message = isset($data['message']) ? $data['message'] : '';
$message = $conn->real_escape_string($message);

// echo 'name: ' . $name . ' ';
// echo 'email: ' . $email . ' ';
// echo 'phone: ' . $phone . ' ';
// echo 'subject: ' . $subject . ' ';
// echo 'message: ' . $message . ' ';

// if ($name && $email && $phone && $subject && $message) {
    $body = "
    Name: $name <br>
    Email: $email <br>
    Phone: $phone <br>
    Message: <br> $message";
    $toEmail = "info@lamassat-qatar.com";
    $php_mailer = new php_mailer();
    $contact_email = $php_mailer->sendMail($toEmail, $subject, $body);
    if ($contact_email) {
        $response['success'] = true;
        $response['message'] = "We have received your message, and we will contact you as soon as possible.";
    } else {
        $response['success'] = false;
        $response['message'] = "Failed to send email. Please try again.";
    }
// } 
// else {
//     $response['success'] = false;
//     $response['message'] = "Please fill in all fields.";
// }

echo json_encode($response);
?>
