/*-------------------------------------------
            Language Script
-------------------------------------------*/

let language = sessionStorage.getItem("language") || "arabic";

$(document).ready(function () {
    setLangStyle();
    dirSwiper();
    // Check if the dictionary exists in sessionStorage
    if (!sessionStorage.getItem("dictionary")) {
        setDictionary();
    }

    $("#lang span").on("click", function () {
    // $("#lang a").on("click", function () {
        // Change language based on the clicked span's ID
        language = $(this).attr("id") === "ar" ? "arabic" : "english";
        // console.log("language: " + language);
        sessionStorage.setItem("language", language);
        
        // Fetch and set the dictionary again
        setDictionary(function () {
            // console.log("should have setDictionary");
            // location.reload();
            window.location.href = "index.php?p=home&lang=" + language;
        });
    });
});

function setLangStyle() {
    const arabicStylesheetId = "arabic-styles";

    if (language === "arabic") {
        if (!$(`#${arabicStylesheetId}`).length) {
            // Prevent caching with a timestamp query parameter
            const timestamp = new Date().getTime();
            $('<link>', {
                id: arabicStylesheetId,
                rel: 'stylesheet',
                href: `assets/css/styles_ar.css?v=${timestamp}`
            }).appendTo('head');
        }
    } else {
        $(`#${arabicStylesheetId}`).remove();
    }
}

function setDictionary(callback) {
    console.log("Fetching dictionary for language: " + language);

    const dictionaryUrl = path_api + "dictionary.php";

    $.ajax({
        url: dictionaryUrl,
        type: 'POST',
        dataType: 'json',
        data: JSON.stringify({ language: language }),
        contentType: "application/json",
        success: function (data) {
            if (data.success && data.dictionary) {
                // console.log(data.dictionary);
                sessionStorage.setItem("dictionary", JSON.stringify(data.dictionary));
                console.log("Dictionary stored successfully.");
                applyDictionary();

                if (typeof callback === "function") {
                    callback();
                }
            } else {
                console.error("Failed to fetch dictionary: " + data.message);
            }
        },
        error: function (xhr, status, error) {
            console.error("Error fetching dictionary:", error);
        }
    });
}

function dirSwiper(){
    $('[dir]').each(function () {
        if (language == "arabic") {
            $(this).attr('dir', 'rtl')
                   .removeClass('swiper-ltr')
                   .addClass('swiper-rtl');
        } else {
            $(this).attr('dir', 'ltr')
                   .removeClass('swiper-rtl')
                   .addClass('swiper-ltr');
        }
    });
}

/*-------------------------------------------
            END of Language Script
-------------------------------------------*/ 
