$(document).ready(function() {

    setDictionary();
    applyDictionary();
    
});

function setDictionary() {
    language = sessionStorage.getItem("language") || "english";
    
    console.log("language: " + language);

    const dictionaryUrl = path_api + "dictionary.php";

    $.ajax({
        url: dictionaryUrl,
        type: 'POST',
        dataType: 'json',
        data: JSON.stringify({ language: language }),
        contentType: "application/json",
        success: function(data) {
            if (data.success && data.dictionary) {
                sessionStorage.setItem("dictionary", JSON.stringify(data.dictionary));
                console.log("Dictionary stored in sessionStorage: ", data.dictionary);
                applyDictionary();
            } else {
                console.log("Failed to fetch data: " + data.message);
            }
        },
        error: function(xhr, status, error) {
            console.error('Error fetching dictionary:', error);
        }
    });
}

function applyDictionary() {
    const dictionary = JSON.parse(sessionStorage.getItem("dictionary"));

    if (dictionary) {
        $('[name]').each(function() {
            const name = $(this).attr('name');
            if (dictionary[name]) {
                if ($(this).is('input, text')) {
                    // Update the placeholder for input
                    $(this).attr('placeholder', dictionary[name]);
                } else if ($(this).is('textarea, text')){
                    // Update placeholder for textarea
                    $(this).attr('placeholder', dictionary[name]);
                } else {
                    // Update the text for other elements
                    $(this).text(dictionary[name]);
                }
            }
        });
    } else {
        console.error("Dictionary not found in sessionStorage.");
    }
}
