<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $item_id = intval($_POST['item_id']);
    $quantity = intval($_POST['quantity']);
    $size_id = intval($_POST['size_id']);
    $color_id = intval($_POST['color_id']);
    $type = $_POST['type']; // 'add', 'remove', or 'empty'

    // Check if cart exists in session
    if (!isset($_SESSION['cart'])) {
        $_SESSION['cart'] = array();
    }

    switch ($type) {
        case 'add':
            // Check if item with same item_id, size_id, and color_id exists
            $found = false;
            foreach ($_SESSION['cart'] as $key => $item) {
                if ($item['id'] === $item_id && $item['size_id'] === $size_id && $item['color_id'] === $color_id) {
                    // If the item exists, update the quantity
                    $_SESSION['cart'][$key]['quantity'] += $quantity;
                    $found = true;
                    break;
                }
            }

            // If item wasn't found, add it to the cart
            if (!$found) {
                $_SESSION['cart'][] = array(
                    'id' => $item_id,
                    'size_id' => $size_id,
                    'color_id' => $color_id,
                    'quantity' => $quantity
                );
            }
            break;

        case 'remove':
            // Iterate through the cart and remove the item
            foreach ($_SESSION['cart'] as $key => $item) {
                if ($item['id'] === $item_id && $item['size_id'] === $size_id && $item['color_id'] === $color_id) {
                    unset($_SESSION['cart'][$key]);
                    break;
                }
            }

            // Re-index the array to ensure consistent indexes
            $_SESSION['cart'] = array_values($_SESSION['cart']);
            break;

        case 'empty':
            // Empty the cart
            unset($_SESSION['cart']);
            break;

        default:
            echo "Invalid cart operation";
            break;
    }
}
