/* ---------------------------------------------
                On Init
--------------------------------------------- */

$(document).ready(function() {
    get_count(); 
});

/* ---------------------------------------------
Update Cart JS
--------------------------------------------- */

// function update_cart(type, item_id = null, item_name = null, item_price = null) {
// function update_cart(type, item_id = null, item_name = null) {
// function update_cart(type, item_id = null, item_name = null, size_id = null, color_id = null) {
//   // Get quantity from the input field if it's an add operation
//   let quantity = type === 'add' ? parseInt($("#quantity").val()) : 0;
  
//     color_id = color_id !== null ? color_id : ($('#select-color').val() || '0');
//     size_id = size_id !== null ? size_id : ($('#select-size').val() || '0');

// //   console.log("item_id: "+ item_id);
// //   console.log("item_name: "+ item_name);
// //   console.log("item_price: "+ item_price);
// //   console.log("item_color: "+ item_color);
// //   console.log("item_size: "+ item_size);
// //   console.log("type: "+ type);

//   if (type === 'add') {
//     // console.log("quantity: " + quantity);
//   }

//   $.ajax({
//     url: "cart/cart_function.php",
//     type: "POST",
//     data: {
//       item_id: item_id,
//     //   item_name: item_name,
//     //   item_price: item_price,
//       quantity: quantity,
//       color_id: color_id,
//       size_id: size_id,
//       type: type
//     },
//     success: function (response) {
//         if (type === 'remove') {
//             if (language === 'arabic') {
//                 response = "تم إزالة العنصر من السلة.";
//             } else {
//                 response = "Item removed from the cart.";
//             }
//         } else if (type === 'empty') {
//             if (language === 'arabic') {
//                 response = "تم إفراغ السلة.";
//             } else {
//                 response = "Cart has been emptied.";
//             }
//         } else if (type === 'add') {
//             if (language === 'arabic') {
//                 response = "تمت إضافة العنصر إلى سلة التسوق.";
//             } else {
//                 response = "Item added to cart.";
//             }
//         }


//       $("#prompt-body").text(response);
//       $("#promptModalLabel").text(item_name);
//       $('#promptModal').modal('show');

//       if (type === 'remove' || type === 'empty') {
//         $('#promptModal').on('hidden.bs.modal', function () {
//           location.reload();
//         });
//       }
//       get_count();
//     },
//     error: function (jqXHR, textStatus, errorThrown) {
//       alert(
//         "There was an issue updating the cart. Please try again."
//       );
//     },
//   });
// }

function update_cart(type, item_id = null, item_name = null, size_id = null, color_id = null) {
    // Get quantity from the input field if it's an add operation
    let quantity = type === 'add' ? parseInt($("#quantity").val()) : 0;

    // Check if size and color are present, and assign default values if not
    color_id = color_id !== null ? color_id : ($('#select-color').length ? $('#select-color').val() || '0' : null);
    size_id = size_id !== null ? size_id : ($('#select-size').length ? $('#select-size').val() || '0' : null);

    // Validation for color and size
    if ($('#select-color').length && (!color_id || color_id === '0')) {
        const colorMessage = language === 'arabic' 
            ? "يرجى اختيار لون متاح." 
            : "Please select a valid color.";
        $("#cart-box").text(colorMessage);
        return;
    }

    if ($('#select-size').length && (!size_id || size_id === '0')) {
        const sizeMessage = language === 'arabic' 
            ? "يرجى اختيار حجم متاح." 
            : "Please select a valid size.";
        $("#cart-box").text(sizeMessage);
        return;
    }


    $.ajax({
        url: "cart/cart_function.php",
        type: "POST",
        data: {
            item_id: item_id,
            quantity: quantity,
            color_id: color_id,
            size_id: size_id,
            type: type
        },
        success: function (response) {
            // Define response messages for different languages
            if (type === 'remove') {
                response = language === 'arabic' ? "تم إزالة العنصر من السلة." : "Item removed from the cart.";
            } else if (type === 'empty') {
                response = language === 'arabic' ? "تم إفراغ السلة." : "Cart has been emptied.";
            } else if (type === 'add') {
                response = language === 'arabic' ? "تمت إضافة العنصر إلى سلة التسوق." : "Item added to cart.";
            }

            // Show response in modal
            $("#prompt-body").text(response);
            $("#promptModalLabel").text(item_name);
            $('#promptModal').modal('show');

            // Reload page after modal for remove or empty actions
            if (type === 'remove' || type === 'empty') {
                $('#promptModal').on('hidden.bs.modal', function () {
                    location.reload();
                });
            }

            // Update cart count
            get_count();
        },
        error: function (jqXHR, textStatus, errorThrown) {
            alert("There was an issue updating the cart. Please try again.");
        },
    });
}



/* ---------------------------------------------
Update Cart END JS
--------------------------------------------- */

/* ---------------------------------------------
Checkout JS
--------------------------------------------- */

function checkout() {
    // console.log("clicked checkout btn");
    
    let name = $("#name").val();
    let phone = $("#phone").val();
    let address = $("#address").val();
    let notes = $("#notes").val();
    let restoID = $("#restoID").val();
    let whatsNumber = $("#whatsNumber").val();

    //   console.log("name: "+ name);
    //   console.log("phone: "+ phone);
    //   console.log("address: "+ address);
    //   console.log("notes: "+ notes);
    //   console.log("restoID: "+ restoID);
    //   console.log("whatsNumber: "+ whatsNumber);
    
    var phonePattern = /^[0-9]+$/;

    if (!name || !phone || !address || !notes || !restoID || !whatsNumber) {
        $("#checkoutBox").html("Please fill all the above fields.");
    } else if (name.length < 3) {
        $("#checkoutBox").html("Name must be at least 3 characters long.");
    } else if (!phonePattern.test(phone) || phone.length < 6) {
        $("#checkoutBox").html("Phone number must contain only numbers and be at least 6 characters long.");
    } else {
        $("#checkoutBox").html("Please wait, processing your order...");

        $.ajax({
            url: "checkout_order.php",
            type: "POST",
            data: {
                name: name,
                phone: phone,
                address: address,
                notes: notes,
                restoID: restoID,
            },
            success: function (response) {
                //   console.log("Success Response.");
                $("#checkoutBox").html("Order received! Redirecting to WhatsApp...");
                // alert("Tomare");
                let whatsAppUrl = `https://wa.me/${whatsNumber}?text=${encodeURIComponent(response)}`;
                window.location.href = whatsAppUrl;
                // window.open(whatsAppUrl, "_blank");
            },
            error: function () {
                //   alert('There was an error placing the order.');
                $("#checkoutBox").html(
                    "There was an error placing the order. Please try again."
                );
            },
        });
    }
}

/* ---------------------------------------------
Checkout END JS
--------------------------------------------- */

/* ---------------------------------------------
Get Cart Count JS
--------------------------------------------- */

function get_count() {
    $.ajax({
        url: 'cart/get_cart_count.php',
        type: 'GET',
        success: function (response) {
            $('#cart_count').text(response);
        },
        error: function () {
            console.log('Error fetching cart count');
        }
    });
}

/* ---------------------------------------------
Get Cart Count END JS
--------------------------------------------- */

/*-------------------------------------------------
            Change Quantity
-------------------------------------------------*/ 

function changeQuantity(change, elementId) {
    var quantityInput = document.getElementById(elementId);
    var currentValue = parseInt(quantityInput.value);
    var newValue = currentValue + change;
    if (newValue >= 1) {
        quantityInput.value = newValue;
    }
}

/*-------------------------------------------------
Change Quantity END
-------------------------------------------------*/ 