<?php
$client_id = $_SESSION["client_id"];
    if ($client_id != "") {
      $disabled = "disabled";
    } else {
        $disabled = null;
    }
    
// var_dump ($_SESSION["cart"]);
?>

<!-- ======= Breadcrumb Section ======= -->
<section class="bg-bread">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1 class="" name="checkout">Checkout</h1>
                <h4 class=""><span name="home">Home</span> / <span name="checkout">Checkout</span></h4>
            </div>
        </div>
    </div>
</section>
<!-- ====== End Breadcrumb Section ====== -->

<!-- Checkout Start -->
<section>
    <div class="container">
        <!-- Form Start -->
        <form id="entireForm" action="#" method="POST" role="form">
            <div class="row">
                
                <!-- Client Col -->
                <div class="col-xl-9 col-lg-8 col-md-12">
                    <div class="row">
                        <!--<form id="checkoutForm" action="#" method="POST" role="form">-->
                        <div>

                            <div class="col-md-12 mb-3">
                                <label class="form-label" name="first_name">First Name</label>
                                <input class="form-control rounded-3" name="first_name" id="first-name" type="text" placeholder="Enter Your First Name" required="" <?php echo $disabled; ?>>
                            </div>

                            <div class="col-md-12 mb-3">
                                <label class="form-label" name="last_name">Last Name</label>
                                <input class="form-control rounded-3" name="last_name" id="last-name" type="text" placeholder="Enter Your Last Name" required="" <?php echo $disabled; ?>>
                            </div>

                            <div class="col-md-12 mb-3">
                                <label class="form-label" name="your_email">Email</label>
                                <input class="form-control rounded-3" name="your_email" id="email" type="email" placeholder="Enter Your Email" required="" <?php echo $disabled; ?>>
                            </div>

                            <div class="col-md-12 mb-3">
                                <label class="form-label" name="your_phone">Phone</label>
                                <input class="form-control rounded-3" name="your_phone" id="phone" type="number" placeholder="Enter Your Phone" required="" <?php echo $disabled; ?>>
                            </div>

                            <div class="col-md-12 mb-3">
                                <label class="form-label" name="your_address">Address</label>
                                <input class="form-control rounded-3" name="your_address" id="address" type="text" placeholder="Enter Your Address" required="" <?php echo $disabled; ?>>
                            </div>

                            <div class="col-md-12 mb-3">
                                <label class="form-label" name="notes">Notes</label>
                                <input class="form-control rounded-3" name="your_notes" id="notes" type="text" placeholder="Notes...">
                            </div>

                            <!--</form>-->
                        </div>
                    </div>
                </div>
                <!-- Client End -->

                <!-- Checkout Start -->
                <div class="col-xl-3 col-lg-4 col-md-12">
                    <h4 class="" name="your_order">Your Order</h4>
                    <ul class="" id="cartItemList">
                        <!--<input type="hidden" name="coupon" value="">-->
                        <li name="no_items"> No Items</li>
                    </ul>

                    <table class="table table-borderless table-striped" id="">
                        <tr>
                            <th class="rounded-start" name="have_coupon">Have a Coupon?</th>
                        </tr>
                    </table>
                    <div class="position-relative">
                        <input type="text" name="coupon" id="coupon-input" class="form-control mb-4" placeholder="Enter a valid coupon">
                        <button name="submit" class="newsletter-btn rounded-end" id="coupon-submit">Submit</button>
                    </div>
                    <p id="msg-box"></p>

                    <ul class="list-none">
                        <li><span name="subtotal">Subtotal</span> <span style="float: right;" id="cartSubTotal"> <?php echo $currency ?> 0</span></li>
                        <li><span name="discount">Discount</span> <span style="float: right;" id="orderDiscount">%0</span></li>
                        <hr>
                        <li><span name="total">Total</span> <span style="float: right;" id="orderTotal"> <?php echo $currency ?> 0</span></li>
                    </ul>
                    <div class="row">
                        <div class="col-md-12">
                            <!--<input type="hidden" name="coupon" value="">-->
                            <div class="form-group">
                                <button type="button" name="place_order" class="btn shopBtn" id="checkout-btn" <?php echo (isset($_SESSION['cart']) && count($_SESSION['cart']) > 0) ? '' : 'disabled'; ?>>Place Order</button>
                            </div>
                            <div>
                                <!--<p class="mt-2" id="msg-box">-->
                                <!--Please don't close this page, until the payment and order are completed.-->
                                <!--</p>-->
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Checkout End -->
            </div>
            
        </form>
        <!-- End Form -->
    </div>
</section>
<!-- Checkout End -->

<script>

let total;
let discount;


$(document).ready(function() {
    loadCartItems();
    if (<?php echo isset($_SESSION['client_id']) ? 'true' : 'false'; ?>) {
        getClient();
    }
    $('#checkout-btn').on('click', function() {
        orderItem();
    });
});

function loadCartItems() {
    const cart = <?php echo json_encode($_SESSION["cart"]); ?>;
    const path_api = "<?php echo $path_api; ?>";
    total = 0;
    
    // Clear the cart item list before adding new items
    $('#cartItemList').empty();

    // Check if the cart is empty
    if ($.isEmptyObject(cart)) {
        $('#cartItemList').append('<li>No Items</li>');
        $('#cartSubTotal').text('<?php echo $currency; ?> 0.00');
        return;
    }

    // Loop through the cart and fetch item details
    $.each(cart, function(itemId, cartItem) {
        const productId = parseInt(itemId);
        const apiUrl = `${path_api}item.php?id=${productId}`;

        $.ajax({
            url: apiUrl,
            method: 'GET',
            dataType: 'json',
            success: function(data) {
                if (data.success && data.objects.length > 0) {
                    const item = data.objects[0];

                    // Determine price (use price_discount if available)
                    const itemPrice = (item.price_discount && item.price_discount > 0) ? item.price_discount : item.price;

                    // Calculate total for this item based on price and quantity
                    const itemTotal = parseFloat(itemPrice) * parseInt(cartItem.quantity);
                    total += itemTotal;

                    // Append the item name, quantity, and price to the cart list
                    $('#cartItemList').append(`<li>${item.name} (x${cartItem.quantity}) - <?php echo $currency; ?> ${parseFloat(itemPrice).toFixed(2)}</li>`);

                    // Update the cart total
                    $('#cartSubTotal').text(`<?php echo $currency; ?> ${total.toFixed(2)}`);
                    $('#orderTotal').text(`<?php echo $currency; ?> ${total.toFixed(2)}`);
                } else {
                    console.error('Item details not found for product ID:', productId);
                }
            },
            error: function(xhr, status, error) {
                console.error('Error fetching item details:', error);
            }
        });
    });
}

$("#coupon-submit").on("click", function (e) {
    e.preventDefault();
    setCoupon();
  });

function setCoupon() {
    const path_api = "<?php echo $path_api; ?>";
    const urlCoupon = `${path_api}coupon.php`;
    let coupon = $("#coupon-input").val().trim();

    if (!coupon) {
        if (language === 'arabic') {
            $("#msg-box").html("من فضلك أدخل قسيمة ساري المفعول.");
        } else {
            $("#msg-box").html("Please type a valid input.");
        }

        return;
    }

    if (language === 'arabic') {
        $("#msg-box").html("انتظر من فضلك.");
    } else {
        $("#msg-box").html("Please wait.");
    }

    $.ajax({
        url: urlCoupon,
        type: "POST",
        data: JSON.stringify({ coupon: coupon }),
        contentType: "application/json",
        dataType: "json",
        success: function (response) {
            if (response.success) {
                $("#msg-box").html(response.message);
                discount = response.coupon_discount;
                $("#orderDiscount").html("%"+response.coupon_discount);
                setTotal();
            } else {
                $("#msg-box").html(response.message);
            }
        },
        error: function () {
            $("#msg-box").html("An error occurred. Please try again later.");
        },
    });
}

function setTotal() {
    const discountAmount = total * (discount / 100);
    const finalTotal = total - discountAmount;

    $("#orderTotal").text(`<?php echo $currency; ?>${finalTotal.toFixed(2)}`);
}


// --------------------------------------------------------------- //

function getClient() {
    let urlLog = '<?php echo $path_api; ?>client/client_info.php';
    let client_id = '<?php echo isset($_SESSION['client_id']) ? $_SESSION['client_id'] : 0; ?>';
    
    $.ajax({
        url: urlLog,
        type: 'POST',
        data: JSON.stringify({
            client_id: client_id
        }),
        contentType: 'application/json',
        success: function(response) {
            if (response.success) {
                $('#first-name').val(response.first_name);
                $('#last-name').val(response.last_name);
                $('#email').val(response.email);
                $('#phone').val(response.phone_number);
                $('#address').val(response.address);
            } else {
                console.log(response.message);
            }
        },
        error: function(xhr, status, error) {
            $('#msg-box').html('An error occurred. Please try again later.');
        }
    });
}

// ------------------------------------------------------------ //

function orderItem() {
    let urlOrder = 'https://blackmoonclothing.com/cart/fatoura_payment.php';
    
    // console.log("urlOrder: " + urlOrder);
    
    // console.log("discount: " + discount);

    // Get form values
    const firstName = $('#first-name').val().trim();
    const lastName = $('#last-name').val().trim();
    const email = $('#email').val().trim();
    const phone = $('#phone').val().trim();
    const address = $('#address').val().trim();
    const notes = $('#notes').val().trim();
    
    if (language === 'arabic') {
        if (firstName.length < 3) {
            $("#msg-box").html("يجب أن يتكون الاسم الأول من 3 أحرف أو أكثر.");
            return false;
        }
        if (lastName.length < 3) {
            $("#msg-box").html("يجب أن يتكون اسم العائلة من 3 أحرف أو أكثر.");
            return false;
        }
        var email_pattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (!email.match(email_pattern)) {
            $("#msg-box").html("البريد الإلكتروني غير صحيح. يرجى استخدام التنسيق email@example.com.");
            return false;
        }
        var phone_pattern = /^[0-9]{6,}$/;
        if (!phone.match(phone_pattern)) {
            $("#msg-box").html("يجب أن يتكون رقم الهاتف من أكثر من 6 أرقام وأرقام فقط.");
            return false;
        }
        if (!address) {
            $("#msg-box").html("يرجى إدخال عنوان صالح.");
            return false;
        }
    } else {
        if (firstName.length < 3) {
            $("#msg-box").html("First Name must be 3 or more characters.");
            return false;
        }
        if (lastName.length < 3) {
            $("#msg-box").html("Last Name must be 3 or more characters.");
            return false;
        }
        var email_pattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (!email.match(email_pattern)) {
            $("#msg-box").html("Your email is incorrect. Please use the format email@example.com.");
            return false;
        }
        var phone_pattern = /^[0-9]{6,}$/;
        if (!phone.match(phone_pattern)) {
            $("#msg-box").html("Phone number must be more than 6 digits and numbers only.");
            return false;
        }
        if (!address) {
            $("#msg-box").html("Please insert a valid address.");
            return false;
        }
    }

    

    let client_id = <?php echo isset($_SESSION['client_id']) ? $_SESSION['client_id'] : 0; ?>;

    // Get the cart session data and prepare it
    const cart = <?php echo json_encode($_SESSION["cart"]); ?>;
    let orderItems = [];

    // Format the cart items into the required structure
    $.each(cart, function(itemId, cartItem) {
        orderItems.push({
            item_id: parseInt(itemId),
            quantity: parseInt(cartItem.quantity)
        });
    });
    
    // console.log(JSON.stringify(orderItems, null, 2));

    if(!discount){
        discount = 0;
    }
    
    //  Requested data in the specified format
    const requestData = {
        order_info: {
            client_id: client_id,
            first_name: firstName,
            last_name: lastName,
            phone_number: phone,
            email: email,
            address: address,
            notes: notes,
            discount: discount,
            total: total
        },
        items: orderItems
    };
    
    // console.log(JSON.stringify(requestData, null, 2));
    // console.log("client_id: " + client_id);

    $.ajax({
        url: urlOrder,
        method: 'POST',
        contentType: 'application/json',
        data: JSON.stringify(requestData),
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                update_cart('empty', '');
                $('#cartItemList').empty();
                $('#msg-box').val(response.message);
                window.location.href = 'index.php?p=thanks';
            } else {
                $('#msg-box').val(response.message);
                // console.log(response.message);
            }
        },
        error: function(xhr, status, error) {
            // console.log("xhr: " + xhr);
            // console.log("status: " + status);
            console.error('Error placing order:', error);
        }
    });
}

</script>
