<?php

session_start();
$page = "home";
if (isset($_GET["p"])) {
    $page = $_GET["p"];
} else {
    $page = "home";
}


include_once "connect.php";
$database_connect = new database_connect();



define('DB_HOST', "localhost");      
define('DB_USER', 'amcserver_user');
define('DB_PASS', 'tag.amc.2013');   
define('DB_NAME', 'amcserver_amcapp');

// Connect to the database
//$conn = mysqli_connect($servername, $username, $password);

$conn = mysqli_connect(DB_HOST, DB_USER, DB_PASS, DB_NAME);
$conn->set_charset("utf8");
if (!$conn) {
    die('Could not connect: ' . $mysqli -> connect_error);
}


if (isset($_GET['lang'])) {
    $language = $_GET['lang'];
    $_SESSION['language'] = $language;
} elseif (isset($_SESSION['language'])) {
    $language = $_SESSION['language'];
} else {
    $language = 'english';
    $_SESSION['language'] = $language;
}
// echo $language;

include_once './class_oop.php';
$class_oop = new class_oop($database_connect, $language);



// echo "Language: " . $language;

// // echo "client_id: " . $client_id;

?>
<!DOCTYPE html>
<html lang="">

<head>
    <title>Souqak</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="format-detection" content="telephone=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="author" content="">
    <meta name="keywords" content="">
    <meta name="description" content="">
    <link rel="icon" type="image/x-icon" href="<?php echo $path_img; ?>/logo.png">
    <link rel="stylesheet" type="text/css" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

      <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet">
      
          <link rel="stylesheet" type="text/css" href="assets/css/styles.css?v=<?php echo strtotime("now"); ?>">
    <!-- Jquery -->
    <script src="assets/js/jquery-1.11.0.min.js"></script>
    <!-- Script Language--> 
    <script type="text/javascript" src="assets/js/language.js?v=<?php echo strtotime("now"); ?>"></script>

    <!--<link rel="preconnect" href="https://fonts.googleapis.com">-->
    <!--<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>-->
    <!--<link href="https://fonts.googleapis.com/css2?family=Jost:wght@300;400;500&family=Lato:wght@300;400;700&display=swap" rel="stylesheet">-->
    <!-- script
    ================================================== -->
    <!--<script src="assets/js/modernizr.js"></script>-->
</head>

<body data-bs-spy="scroll" data-bs-target="#navbar" data-bs-root-margin="0px 0px -40%" data-bs-smooth-scroll="true" tabindex="0">
    <svg xmlns="http://www.w3.org/2000/svg" style="display: none;">
        <symbol id="search" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
            <title>Search</title>
            <path fill="currentColor" d="M19 3C13.488 3 9 7.488 9 13c0 2.395.84 4.59 2.25 6.313L3.281 27.28l1.439 1.44l7.968-7.969A9.922 9.922 0 0 0 19 23c5.512 0 10-4.488 10-10S24.512 3 19 3zm0 2c4.43 0 8 3.57 8 8s-3.57 8-8 8s-8-3.57-8-8s3.57-8 8-8z" />
        </symbol>
        <symbol xmlns="http://www.w3.org/2000/svg" id="user" viewBox="0 0 16 16">
            <path d="M3 14s-1 0-1-1 1-4 6-4 6 3 6 4-1 1-1 1H3Zm5-6a3 3 0 1 0 0-6 3 3 0 0 0 0 6Z" />
        </symbol>
        <symbol xmlns="http://www.w3.org/2000/svg" id="cart" viewBox="0 0 16 16">
            <path d="M0 1.5A.5.5 0 0 1 .5 1H2a.5.5 0 0 1 .485.379L2.89 3H14.5a.5.5 0 0 1 .491.592l-1.5 8A.5.5 0 0 1 13 12H4a.5.5 0 0 1-.491-.408L2.01 3.607 1.61 2H.5a.5.5 0 0 1-.5-.5zM5 12a2 2 0 1 0 0 4 2 2 0 0 0 0-4zm7 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4zm-7 1a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm7 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
        </symbol>
        <svg xmlns="http://www.w3.org/2000/svg" id="chevron-left" viewBox="0 0 16 16">
            <path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0z" />
        </svg>
        <symbol xmlns="http://www.w3.org/2000/svg" id="chevron-right" viewBox="0 0 16 16">
            <path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z" />
        </symbol>
        <symbol xmlns="http://www.w3.org/2000/svg" id="cart-outline" viewBox="0 0 16 16">
            <path d="M0 1.5A.5.5 0 0 1 .5 1H2a.5.5 0 0 1 .485.379L2.89 3H14.5a.5.5 0 0 1 .49.598l-1 5a.5.5 0 0 1-.465.401l-9.397.472L4.415 11H13a.5.5 0 0 1 0 1H4a.5.5 0 0 1-.491-.408L2.01 3.607 1.61 2H.5a.5.5 0 0 1-.5-.5zM3.102 4l.84 4.479 9.144-.459L13.89 4H3.102zM5 12a2 2 0 1 0 0 4 2 2 0 0 0 0-4zm7 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4zm-7 1a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm7 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
        </symbol>
        <symbol xmlns="http://www.w3.org/2000/svg" id="quality" viewBox="0 0 16 16">
            <path d="M9.669.864 8 0 6.331.864l-1.858.282-.842 1.68-1.337 1.32L2.6 6l-.306 1.854 1.337 1.32.842 1.68 1.858.282L8 12l1.669-.864 1.858-.282.842-1.68 1.337-1.32L13.4 6l.306-1.854-1.337-1.32-.842-1.68L9.669.864zm1.196 1.193.684 1.365 1.086 1.072L12.387 6l.248 1.506-1.086 1.072-.684 1.365-1.51.229L8 10.874l-1.355-.702-1.51-.229-.684-1.365-1.086-1.072L3.614 6l-.25-1.506 1.087-1.072.684-1.365 1.51-.229L8 1.126l1.356.702 1.509.229z" />
            <path d="M4 11.794V16l4-1 4 1v-4.206l-2.018.306L8 13.126 6.018 12.1 4 11.794z" />
        </symbol>
        <symbol xmlns="http://www.w3.org/2000/svg" id="price-tag" viewBox="0 0 16 16">
            <path d="M6 4.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm-1 0a.5.5 0 1 0-1 0 .5.5 0 0 0 1 0z" />
            <path d="M2 1h4.586a1 1 0 0 1 .707.293l7 7a1 1 0 0 1 0 1.414l-4.586 4.586a1 1 0 0 1-1.414 0l-7-7A1 1 0 0 1 1 6.586V2a1 1 0 0 1 1-1zm0 5.586 7 7L13.586 9l-7-7H2v4.586z" />
        </symbol>
        <symbol xmlns="http://www.w3.org/2000/svg" id="shield-plus" viewBox="0 0 16 16">
            <path d="M5.338 1.59a61.44 61.44 0 0 0-2.837.856.481.481 0 0 0-.328.39c-.554 4.157.726 7.19 2.253 9.188a10.725 10.725 0 0 0 2.287 2.233c.346.244.652.42.893.533.12.057.218.095.293.118a.55.55 0 0 0 .101.025.615.615 0 0 0 .1-.025c.076-.023.174-.061.294-.118.24-.113.547-.29.893-.533a10.726 10.726 0 0 0 2.287-2.233c1.527-1.997 2.807-5.031 2.253-9.188a.48.48 0 0 0-.328-.39c-.651-.213-1.75-.56-2.837-.855C9.552 1.29 8.531 1.067 8 1.067c-.53 0-1.552.223-2.662.524zM5.072.56C6.157.265 7.31 0 8 0s1.843.265 2.928.56c1.11.3 2.229.655 2.887.87a1.54 1.54 0 0 1 1.044 1.262c.596 4.477-.787 7.795-2.465 9.99a11.775 11.775 0 0 1-2.517 2.453 7.159 7.159 0 0 1-1.048.625c-.28.132-.581.24-.829.24s-.548-.108-.829-.24a7.158 7.158 0 0 1-1.048-.625 11.777 11.777 0 0 1-2.517-2.453C1.928 10.487.545 7.169 1.141 2.692A1.54 1.54 0 0 1 2.185 1.43 62.456 62.456 0 0 1 5.072.56z" />
            <path d="M8 4.5a.5.5 0 0 1 .5.5v1.5H10a.5.5 0 0 1 0 1H8.5V9a.5.5 0 0 1-1 0V7.5H6a.5.5 0 0 1 0-1h1.5V5a.5.5 0 0 1 .5-.5z" />
        </symbol>
        <symbol xmlns="http://www.w3.org/2000/svg" id="star-fill" viewBox="0 0 16 16">
            <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.282.95l-3.522 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z" />
        </symbol>
        <symbol xmlns="http://www.w3.org/2000/svg" id="star-empty" viewBox="0 0 16 16">
            <path d="M2.866 14.85c-.078.444.36.791.746.593l4.39-2.256 4.389 2.256c.386.198.824-.149.746-.592l-.83-4.73 3.522-3.356c.33-.314.16-.888-.282-.95l-4.898-.696L8.465.792a.513.513 0 0 0-.927 0L5.354 5.12l-4.898.696c-.441.062-.612.636-.283.95l3.523 3.356-.83 4.73zm4.905-2.767-3.686 1.894.694-3.957a.565.565 0 0 0-.163-.505L1.71 6.745l4.052-.576a.525.525 0 0 0 .393-.288L8 2.223l1.847 3.658a.525.525 0 0 0 .393.288l4.052.575-2.906 2.77a.565.565 0 0 0-.163.506l.694 3.957-3.686-1.894a.503.503 0 0 0-.461 0z" />
        </symbol>
        <symbol xmlns="http://www.w3.org/2000/svg" id="star-half" viewBox="0 0 16 16">
            <path d="M5.354 5.119 7.538.792A.516.516 0 0 1 8 .5c.183 0 .366.097.465.292l2.184 4.327 4.898.696A.537.537 0 0 1 16 6.32a.548.548 0 0 1-.17.445l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256a.52.52 0 0 1-.146.05c-.342.06-.668-.254-.6-.642l.83-4.73L.173 6.765a.55.55 0 0 1-.172-.403.58.58 0 0 1 .085-.302.513.513 0 0 1 .37-.245l4.898-.696zM8 12.027a.5.5 0 0 1 .232.056l3.686 1.894-.694-3.957a.565.565 0 0 1 .162-.505l2.907-2.77-4.052-.576a.525.525 0 0 1-.393-.288L8.001 2.223 8 2.226v9.8z" />
        </symbol>
        <symbol xmlns="http://www.w3.org/2000/svg" id="quote" viewBox="0 0 24 24">
            <path fill="currentColor" d="m15 17l2-4h-4V6h7v7l-2 4h-3Zm-9 0l2-4H4V6h7v7l-2 4H6Z" />
        </symbol>
        <symbol xmlns="http://www.w3.org/2000/svg" id="facebook" viewBox="0 0 24 24">
            <path fill="currentColor" d="M9.198 21.5h4v-8.01h3.604l.396-3.98h-4V7.5a1 1 0 0 1 1-1h3v-4h-3a5 5 0 0 0-5 5v2.01h-2l-.396 3.98h2.396v8.01Z" />
        </symbol>
        <symbol xmlns="http://www.w3.org/2000/svg" id="youtube" viewBox="0 0 32 32">
            <path fill="currentColor" d="M29.41 9.26a3.5 3.5 0 0 0-2.47-2.47C24.76 6.2 16 6.2 16 6.2s-8.76 0-10.94.59a3.5 3.5 0 0 0-2.47 2.47A36.13 36.13 0 0 0 2 16a36.13 36.13 0 0 0 .59 6.74a3.5 3.5 0 0 0 2.47 2.47c2.18.59 10.94.59 10.94.59s8.76 0 10.94-.59a3.5 3.5 0 0 0 2.47-2.47A36.13 36.13 0 0 0 30 16a36.13 36.13 0 0 0-.59-6.74ZM13.2 20.2v-8.4l7.27 4.2Z" />
        </symbol>
        <symbol xmlns="http://www.w3.org/2000/svg" id="twitter" viewBox="0 0 256 256">
            <path fill="currentColor" d="m245.66 77.66l-29.9 29.9C209.72 177.58 150.67 232 80 232c-14.52 0-26.49-2.3-35.58-6.84c-7.33-3.67-10.33-7.6-11.08-8.72a8 8 0 0 1 3.85-11.93c.26-.1 24.24-9.31 39.47-26.84a110.93 110.93 0 0 1-21.88-24.2c-12.4-18.41-26.28-50.39-22-98.18a8 8 0 0 1 13.65-4.92c.35.35 33.28 33.1 73.54 43.72V88a47.87 47.87 0 0 1 14.36-34.3A46.87 46.87 0 0 1 168.1 40a48.66 48.66 0 0 1 41.47 24H240a8 8 0 0 1 5.66 13.66Z" />
        </symbol>
        <symbol xmlns="http://www.w3.org/2000/svg" id="instagram" viewBox="0 0 256 256">
            <path fill="currentColor" d="M128 80a48 48 0 1 0 48 48a48.05 48.05 0 0 0-48-48Zm0 80a32 32 0 1 1 32-32a32 32 0 0 1-32 32Zm48-136H80a56.06 56.06 0 0 0-56 56v96a56.06 56.06 0 0 0 56 56h96a56.06 56.06 0 0 0 56-56V80a56.06 56.06 0 0 0-56-56Zm40 152a40 40 0 0 1-40 40H80a40 40 0 0 1-40-40V80a40 40 0 0 1 40-40h96a40 40 0 0 1 40 40ZM192 76a12 12 0 1 1-12-12a12 12 0 0 1 12 12Z" />
        </symbol>
        <symbol xmlns="http://www.w3.org/2000/svg" id="linkedin" viewBox="0 0 24 24">
            <path fill="currentColor" d="M6.94 5a2 2 0 1 1-4-.002a2 2 0 0 1 4 .002zM7 8.48H3V21h4V8.48zm6.32 0H9.34V21h3.94v-6.57c0-3.66 4.77-4 4.77 0V21H22v-7.93c0-6.17-7.06-5.94-8.72-2.91l.04-1.68z" />
        </symbol>
        <symbol xmlns="http://www.w3.org/2000/svg" id="nav-icon" viewBox="0 0 16 16">
            <path d="M14 10.5a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 .5-.5zm0-3a.5.5 0 0 0-.5-.5h-7a.5.5 0 0 0 0 1h7a.5.5 0 0 0 .5-.5zm0-3a.5.5 0 0 0-.5-.5h-11a.5.5 0 0 0 0 1h11a.5.5 0 0 0 .5-.5z" />
        </symbol>
        <symbol xmlns="http://www.w3.org/2000/svg" id="close" viewBox="0 0 16 16">
            <path d="M2.146 2.854a.5.5 0 1 1 .708-.708L8 7.293l5.146-5.147a.5.5 0 0 1 .708.708L8.707 8l5.147 5.146a.5.5 0 0 1-.708.708L8 8.707l-5.146 5.147a.5.5 0 0 1-.708-.708L7.293 8 2.146 2.854Z" />
        </symbol>
        <symbol xmlns="http://www.w3.org/2000/svg" id="navbar-icon" viewBox="0 0 16 16">
            <path d="M14 10.5a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 .5-.5zm0-3a.5.5 0 0 0-.5-.5h-7a.5.5 0 0 0 0 1h7a.5.5 0 0 0 .5-.5zm0-3a.5.5 0 0 0-.5-.5h-11a.5.5 0 0 0 0 1h11a.5.5 0 0 0 .5-.5z" />
        </symbol>
    </svg>

    <div class="search-popup">

        <div id="search-popup-close">
            <svg class="close">
                <use xlink:href="#close"></use>
            </svg>
        </div>

        <div class="search-popup-container">

            <form role="search" method="get" class="search-form" action="">
                <h2 name="search">Search</h2>
                <input type="search" id="search-term" name="search-term" class="search-field" placeholder="Looking For Something..."  value="" />
                <!--<button type="submit" class="search-submit"><svg class="search"><use xlink:href="#search"></use></svg></button>-->
            </form>

            <div id="search-container">

            </div>

            <!--<h5 class="cat-list-title">Browse Categories</h5>-->

            <!--<ul class="cat-list">-->
            <!--  <li class="cat-list-item">-->
            <!--    <a href="#" title="Mobile Phones">Mobile Phones</a>-->
            <!--  </li>-->
            <!--  <li class="cat-list-item">-->
            <!--    <a href="#" title="Smart Watches">Smart Watches</a>-->
            <!--  </li>-->
            <!--  <li class="cat-list-item">-->
            <!--    <a href="#" title="Headphones">Headphones</a>-->
            <!--  </li>-->
            <!--  <li class="cat-list-item">-->
            <!--    <a href="#" title="Accessories">Accessories</a>-->
            <!--  </li>-->
            <!--  <li class="cat-list-item">-->
            <!--    <a href="#" title="Monitors">Monitors</a>-->
            <!--  </li>-->
            <!--  <li class="cat-list-item">-->
            <!--    <a href="#" title="Speakers">Speakers</a>-->
            <!--  </li>-->
            <!--  <li class="cat-list-item">-->
            <!--    <a href="#" title="Memory Cards">Memory Cards</a>-->
            <!--  </li>-->
            <!--</ul>-->

        </div>
    </div>

    <header id="header" class="site-header header-scrolled">
        <nav id="header-nav" class="navbar navbar-expand-lg px-3">
            <div class="container">
                <a class="navbar-brand" href="index.php?p=home">
                    <img src="assets/uploads/logo.png" class="logo-nav">
                </a>
                <button class="navbar-toggler d-flex d-lg-none order-3 p-2" type="button" data-bs-toggle="offcanvas" data-bs-target="#bdNavbar" aria-controls="bdNavbar" aria-expanded="false" aria-label="Toggle navigation">
                    <svg class="navbar-icon">
                        <use xlink:href="#navbar-icon"></use>
                    </svg>
                </button>
                <div class="offcanvas offcanvas-end" tabindex="-1" id="bdNavbar" aria-labelledby="bdNavbarOffcanvasLabel">
                    <div class="offcanvas-header px-4 pb-0">
                        <a class="navbar-brand" href="index.php?p=home">
                            <img src="assets/uploads/logo.png" class="logo-nav">
                        </a>
                        <button type="button" class="btn-close btn-close-black" data-bs-dismiss="offcanvas" aria-label="Close" data-bs-target="#bdNavbar"></button>
                    </div>
                    <div class="offcanvas-body">
                        <ul id="navbar" class="navbar-nav text-uppercase justify-content-end align-items-center flex-grow-1 pe-3">
                            <li class="nav-item">
                                <a class="nav-link me-4 <?php if ($page == 'home') {
                                                            echo 'activeNav';
                                                        } ?>" href="index.php?p=home" name="home">Home</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link me-4 <?php if ($page == 'categories') {
                                                            echo 'activeNav';
                                                        } ?>" href="index.php?p=categories" name="categories">Categories</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link me-4 <?php if ($page == 'products' && $_GET["sort_items"]!=6) {
                                                            echo 'activeNav';
                                                        } ?>" href="index.php?p=products" name="products">Products</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link me-4 <?php if ($page == 'products' && $_GET["sort_items"]==6) {
                                                            echo 'activeNav';
                                                        } ?>" href="index.php?p=products&sort_items=6" name="offers">Offers</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link me-4 <?php if ($page == 'about') {
                                                            echo 'activeNav';
                                                        } ?>" href="index.php?p=about" name="about">About</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link me-4 <?php if ($page == 'contact') {
                                                            echo 'activeNav';
                                                        } ?>" href="index.php?p=contact" name="contact">Contact</a>
                            </li>
                            <!--<li class="nav-item dropdown">-->
                            <!--  <a class="nav-link me-4 dropdown-toggle link-dark" data-bs-toggle="dropdown" href="#" role="button" aria-expanded="false">Pages</a>-->
                            <!--  <ul class="dropdown-menu">-->
                            <!--    <li>-->
                            <!--      <a href="#" class="dropdown-item">About</a>-->
                            <!--    </li>-->
                            <!--    <li>-->
                            <!--      <a href="#" class="dropdown-item">Blog</a>-->
                            <!--    </li>-->
                            <!--    <li>-->
                            <!--      <a href="#" class="dropdown-item">Shop</a>-->
                            <!--    </li>-->
                            <!--    <li>-->
                            <!--      <a href="#" class="dropdown-item">Cart</a>-->
                            <!--    </li>-->
                            <!--    <li>-->
                            <!--      <a href="#" class="dropdown-item">Checkout</a>-->
                            <!--    </li>-->
                            <!--    <li>-->
                            <!--      <a href="#" class="dropdown-item">Single Post</a>-->
                            <!--    </li>-->
                            <!--    <li>-->
                            <!--      <a href="#" class="dropdown-item">Single Product</a>-->
                            <!--    </li>-->
                            <!--    <li>-->
                            <!--      <a href="#" class="dropdown-item">Contact</a>-->
                            <!--    </li>-->
                            <!--  </ul>-->
                            <!--</li>-->
                            <li class="nav-item">
                                <div class="user-items">
                                    <ul class="header-svg">
                                        <li class="search-item">
                                            <a href="#" class="search-button">
                                                <svg class="search">
                                                    <use xlink:href="#search"></use>
                                                </svg>
                                            </a>
                                        </li>
                                        <li class="">
                                            <a href="index.php?p=profile">
                                                <svg class="user">
                                                    <use xlink:href="#user"></use>
                                                </svg>
                                            </a>
                                        </li>
                                        <li class="">
                                            <a href="index.php?p=cart" class="position-relative">
                                                <p class="cart_count" id="cart_count"></p>
                                                <svg class="cart">
                                                    <use xlink:href="#cart"></use>
                                                </svg>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </li>
                            <li>
                                <div id="lang">
                                    <span id="en">EN</span> / <span id="ar">AR</span>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>
    </header>

    <main>
        <?php

        switch ($page) {
            case "home":
                include_once './home.php';
                break;
            case "about":
                include_once './about.php';
                break;
            case "contact":
                include_once './contact.php';
                break;
            case "policy":
                include_once './policy.php';
                break;
            case "terms":
                include_once './terms.php';
                break;

            case "products":
                include_once './products.php';
                break;
            case "product":
                include_once './product.php';
                break;
            case "categories":
                include_once './categories.php';
                break;

            case "profile":
                include_once "./profile/profile.php";
                break;
            case "login":
                include_once "./profile/login.php";
                break;
            case "create_user":
                include_once "./profile/create_user.php";
                break;
            case "client_info":
                include_once "./profile/client_info.php";
                break;
            case "client_password":
                include_once "./profile/client_password.php";
                break;
            case "forget_password":
                include_once "./profile/forget_password.php";
                break;
            case "reset_password":
                include_once "./profile/reset_password.php";
                break;
            case "update_password":
                include_once "./profile/update_password.php";
                break;
            case "my_orders":
                include_once "./profile/my_orders.php";
                break;

            case "user_thank_you":
                include_once './cart/user_thank_you.php';
                break;
            case "make_payment":
                include_once './cart/make_payment.php';
                break;
            case "cart":
                include_once './cart/cart.php';
                break;
            case "cart_ajax":
                include_once './cart/cart_ajax.php';
                break;
            case "checkout":
                include_once './cart/checkout.php';
                break;
            case (strpos($page, 'thanks') === 0): 
        include_once './cart/thanks.php';
        break;
            case "payments":
                include_once './cart/fatoura_payment.php';
                break;
            default:
                include_once './home.php';
        }

        ?>
    </main>

<!-- Button trigger modal -->


<!-- Modal -->

    <!-- Button to trigger modal -->
  
    
    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Modal Title</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            
            
            
            <section class="position-relative">
    <div class="container">
        
        <div class="row justify-content-between gy-4">
            <div class="col-md-5">
                
                <img id="product-image" src="./assets/uploads/laptop2.jpg" alt="Laptop" class="img-fluid mb-4">
                
                <ul id="image-list" class="image-list">
                    <li><img src="./assets/uploads/laptop2.jpg" alt="Laptop" class="img-fluid"></li>
                                    </ul>
                
            </div>
            <style>
                #image-list li{
                    width: 100px;
                    height: 120px;
                    margin-left: 3px;
                    margin-right: 3px;
                }
                 #image-list li img{
                      width: 100px;
                    height: 120px;
                    object-fit: cover;
                    border-radius: 5px;
    border: solid 1px #dadada;
                 }
                 #product-image{
                     max-height: 380px;
                 }
            </style>
            <!-- End Info Item -->
            <div class="col-md-6 mt-4">
                <h2 class="section-title section_title" id="product-title">
                    Laptop                </h2>
                <div class="d-flex align-items-center">
                    <div class="d-flex flex-row" id="product-price" data-discount="10">
                        
                                    <h4 id="main_price" class="item-price"><span name="currency">QAR</span> 495.00</h4>
                                    <del id="og_price" class="mx-2"><span name="currency">QAR</span> 550.00</del>
                                                    </div>
                    <!--<span>-->
                    <!--    (Per Piece)-->
                    <!--</span>-->
                </div>
                
                <div id="product_out">
                                    </div>
                
                <div class="row mb-2" id="product-options">
                    
                                            <div class="col-md-6" id="product-size">
                            <label name="size" for="select-size">Size:</label>
                            <select id="select-size" class="form-select">
                                <option name="select_size" value="" disabled="" selected="">Select Size</option>
                                <option value="1" data-price="300" data-discount="25">Smol</option><option value="2" data-price="400" data-discount="26">Medium</option><option value="3" data-price="500" data-discount="27">Large</option>                            </select>
                        </div>
                                        
                    
                </div>
                
                <div class="col-12">
                    <p id="cart-box"></p>
                </div>
                
                <div class="d-flex flex-row align-items-center">
                    <div class="quantity-control">
                        <!--<button type="button" class="qty-btn minus" onclick="changeQuantity(-1, 'qty_41')">-</button>-->
                        <!--<input type="text" id="quantity" class="input-text qty input_quantity" value="1" min="1" id="qty_41" readonly>-->
                        <!--<button type="button" class="qty-btn plus" onclick="changeQuantity(1, 'qty_41')">+</button>-->
                        <input type="number" id="quantity" name="quantity" value="1" min="1" class="form-control">
                    </div>
                    <!--<button id="addCart" name="add_to_cart" class="btn btn-dark rounded" type="button" onclick="update_cart('add', 41);" data-toggle="modal" data-target="#exampleModal">Add to cart</button>-->
                    
                    <div id="add_cart_div">
                                                    <button id="addCart" name="add_to_cart" class=" btn-medium btn-light text-uppercase rounded shopBtn" type="button" onclick="update_cart('add', 41, 'Laptop');" data-toggle="modal" data-target="#exampleModal">Add To Cart</button>
                                            </div>
                </div>
                
                <p class="mt-2" id="product-description">
                    Meet the laptop that combines power with versatility. Its sleek design and advanced performance make it ideal for multitasking and entertainment. 
Powered by the latest processor, ample RAM, and fast SSD, it offers smooth, responsive computing for work or play. The high-resolution display provides vibrant colors, while the ergonomic keyboard and precision touchpad add comfort. 
Lightweight and portable with long battery life, this laptop keeps you productive on the go—a perfect blend of performance, style, and mobility.                </p>
                
            </div>
            <!-- End Info Item -->
        </div>
        
    </div>
</section>




          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            <button type="button" class="btn btn-primary">Save changes</button>
          </div>
        </div>
      </div>
    </div>
  


    <footer id="footer" class="overflow-hidden">
        <div class="container">
            <div class="row">
                <div class="footer-top-area">
                    <div class="row d-flex flex-wrap justify-content-between">
                        <div class="col-lg-3 col-sm-6 pb-3">
                            <div class="footer-menu">
                                <img src="assets/uploads/logo.png" alt="logo-footer" class="logo-footer">
                                <p name="footer_text">
                                    Nisi, purus vitae, ultrices nunc. Sit ac sit suscipit hendrerit. Gravida massa volutpat aenean odio erat nullam fringilla.
                                </p>
                                <!--<div class="social-links">-->
                                <!--  <ul class="d-flex list-unstyled">-->
                                <!--    <li>-->
                                <!--      <a href="#">-->
                                <!--        <svg class="facebook">-->
                                <!--          <use xlink:href="#facebook" />-->
                                <!--        </svg>-->
                                <!--      </a>-->
                                <!--    </li>-->
                                <!--    <li>-->
                                <!--      <a href="#">-->
                                <!--        <svg class="instagram">-->
                                <!--          <use xlink:href="#instagram" />-->
                                <!--        </svg>-->
                                <!--      </a>-->
                                <!--    </li>-->
                                <!--    <li>-->
                                <!--      <a href="#">-->
                                <!--        <svg class="twitter">-->
                                <!--          <use xlink:href="#twitter" />-->
                                <!--        </svg>-->
                                <!--      </a>-->
                                <!--    </li>-->
                                <!--    <li>-->
                                <!--      <a href="#">-->
                                <!--        <svg class="linkedin">-->
                                <!--          <use xlink:href="#linkedin" />-->
                                <!--        </svg>-->
                                <!--      </a>-->
                                <!--    </li>-->
                                <!--    <li>-->
                                <!--      <a href="#">-->
                                <!--        <svg class="youtube">-->
                                <!--          <use xlink:href="#youtube" />-->
                                <!--        </svg>-->
                                <!--      </a>-->
                                <!--    </li>-->
                                <!--  </ul>-->
                                <!--</div>-->
                            </div>
                        </div>
                        <div class="col-lg-2 col-sm-6 pb-3 d-flex footer-col">
                            <div class="footer-menu text-uppercase">
                                <h5 class="widget-title pb-2" name="quick_links">Quick Links</h5>
                                <ul class="menu-list list-unstyled text-uppercase">
                                    <li class="menu-item pb-2">
                                        <a href="index.php?p=home" name="home">Home</a>
                                    </li>
                                    <li class="menu-item pb-2">
                                        <a href="index.php?p=about" name="about">About</a>
                                    </li>
                                    <li class="menu-item pb-2">
                                        <a href="index.php?p=products" name="products">Products</a>
                                    </li>
                                    <li class="menu-item pb-2">
                                        <a href="index.php?p=contact" name="contact">Contact</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-3 col-sm-6 pb-3 d-flex footer-col">
                            <div class="footer-menu contact-item">
                                <h5 class="widget-title text-uppercase pb-2" name="contact">Contact</h5>
                                <p>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" class="footer-svg">
                                        <path d="M502.3 190.8c3.9-3.1 9.7-.2 9.7 4.7V400c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V195.6c0-5 5.7-7.8 9.7-4.7 22.4 17.4 52.1 39.5 154.1 113.6 21.1 15.4 56.7 47.8 92.2 47.6 35.7 .3 72-32.8 92.3-47.6 102-74.1 131.6-96.3 154-113.7zM256 320c23.2 .4 56.6-29.2 73.4-41.4 132.7-96.3 142.8-104.7 173.4-128.7 5.8-4.5 9.2-11.5 9.2-18.9v-19c0-26.5-21.5-48-48-48H48C21.5 64 0 85.5 0 112v19c0 7.4 3.4 14.3 9.2 18.9 30.6 23.9 40.7 32.4 173.4 128.7 16.8 12.2 50.2 41.8 73.4 41.4z" />
                                    </svg>
                                    <a href="mailto:info@lamassat-qatar.com">info@lamassat-qatar.com</a>
                                </p>
                                <p>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" class="footer-svg">
                                        <path d="M497.4 361.8l-112-48a24 24 0 0 0 -28 6.9l-49.6 60.6A370.7 370.7 0 0 1 130.6 204.1l60.6-49.6a23.9 23.9 0 0 0 6.9-28l-48-112A24.2 24.2 0 0 0 122.6 .6l-104 24A24 24 0 0 0 0 48c0 256.5 207.9 464 464 464a24 24 0 0 0 23.4-18.6l24-104a24.3 24.3 0 0 0 -14-27.6z" />
                                    </svg>
                                    <a href="+123456789">+123456789</a>
                                </p>
                            </div>
                        </div>
                        <div class="col-lg-4 col-sm-6 pb-3">
                            <div class="footer-menu contact-item">
                                <h5 class="widget-title text-uppercase pb-2" name="subscribe">Subscribe</h5>
                                <p name="subscribe_text">
                                    Stay Connected! Don't miss out on the latest updates, tips, and exclusive offers!
                                </p>
                                <div class="position-relative">
                                    <input type="text" id="newsletter" class="newsletter-input" name="newsletterInput" placeholder="Your Email Address">
                                    <button type="button" class="newsletter-btn" id="newsBtn" name="subscribe">Subscribe</button>
                                </div>
                                <p id="sub-box" class="my-2"></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <hr>
        <div class="mb-3" id="footer-bottom">
            <div class="container">
                <div class="row d-flex flex-wrap justify-content-center">
                    <div class="col-md-4 col-sm-6 text-center">
                   © <?php echo date("Y"); ?> <span name="powered">All Rights Reserved.Powered By</span>
                        <a href="https://amctag.com/">amctag</a>
                    </div>
                    <!--<div class="col-md-4 col-sm-6 text-center">-->
                    <!--  <div class="copyright">-->
                    <!--    <p>-->
                    <!--        Powered by <a href="https://amctag.com/">amctag</a>-->
                    <!--    </p>-->
                    <!--  </div>-->
                    <!--</div>-->
                </div>
            </div>
        </div>
    </footer>

    <!-- =========== Prompt Modal START ============ -->
    <div class="modal fade" id="promptModal" data-bs-keyboard="false" tabindex="-1" aria-labelledby="promptModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header d-flex justify-content-between">
                    <h1 class="modal-title fs-5" id="promptModalLabel">
                    </h1>
                    <button type="button" class="btn-close m-0" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <h4 id="prompt-body">
                    </h4>
                </div>
                <div class="modal-footer d-flex justify-content-between">
                    <button type="button" class="shopBtn" data-bs-dismiss="modal" name="continue_shopping">Continue Shopping</button>
                    <a href="index.php?p=cart" class="shopBtn" name="view_cart">View Cart</a>
                </div>
            </div>
        </div>
    </div>
    <!-- =========== Prompt Modal END ============ -->

    <script>
        $(document).ready(function() {
            // console.log("doc at ready in index");
            $('#search-term').on('input', function() {
                searchItem();
            });
        });

        function searchItem() {
            let limit_search = '&limit=4';
            var search_term = $('#search-term').val();

            if (!search_term.trim()) {
                $('#search-container').html("");
                return;
            }

            let urlSearch = '<?php echo $path_api; ?>item.php?language=' + language + '&search_term=' + search_term + limit_search;

            $.ajax({
                url: urlSearch,
                type: 'GET',
                dataType: 'json',
                success: function(response) {
                    let searchHTML = '';

                    // Check if there are items in the response
                    if (response.objects && response.objects.length > 0) {
                        $.each(response.objects, function(index, search) {
                            let priceHTML = '';

                            // Check if price_discount is null, empty, or 0
                            if (!search.price_discount || search.price_discount == 0) {
                                priceHTML = `<h6><?php echo $currency; ?>${search.price}</h6>`;
                            } else {
                                priceHTML = `
                            <h6><del><?php echo $currency; ?>${search.price}</del></h6>
                            <h6><?php echo $currency; ?>${search.price_discount}</h6>
                        `;
                            }

                            searchHTML += `
                        <a class="row" href="index.php?p=product&id=${search.id}">
                            <div class="col-3">
                                <img src="${search.image[0]}" class="img-fluid" alt="${search.name}">
                            </div>
                            <div class="col-7 d-flex align-items-center justify-content-center">
                                <h6>${search.name}</h6>
                            </div>
                            <div class="col-2 d-flex flex-column align-items-center justify-content-center">
                                ${priceHTML}
                            </div>
                        </a>
                    `;
                        });
                    } else {
                        // No items found
                        if (language === 'arabic') {
                            searchHTML = "<h6 class='mt-4'>لم يتم العثور على عناصر بهذا الاسم</h6>";
                        } else {
                            searchHTML = "<h6 class='mt-4'>No items found with that name</h6>";
                        }
                    }

                    $('#search-container').html(searchHTML);
                },
                error: function(xhr, status, error) {
                    console.error(error);
                }
            });
        }
    </script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js"></script>
    <!--<script src="assets/js/jquery-1.11.0.min.js"></script>-->
    <script src="https://cdn.jsdelivr.net/npm/swiper/swiper-bundle.min.js"></script>
    <script type="text/javascript" src="assets/js/bootstrap.bundle.min.js"></script>
    <!--<script type="text/javascript" src="assets/js/plugins.js"></script>-->
    <script type="text/javascript" src="cart/ecomm.js?v=<?php echo strtotime("now"); ?>"></script>
    <!--<script type="text/javascript" src="assets/js/script.js?v=<?php echo strtotime("now"); ?>"></script>-->
    <!-- Script -->
    <script type="text/javascript" src="assets/js/script.js?v=<?php echo strtotime("now"); ?>"></script>
    <!-- Dictionary -->
    <script type="text/javascript" src="assets/js/dictionary.js?v=<?php echo strtotime("now"); ?>"></script>

</body>

</html>