<?php
session_start();

if (!isset($_SESSION['client_id'])) {
    // $client_id = $_SESSION["client_id"];
    echo '<script>
            window.location.href = "index.php?p=login";
          </script>';
    exit;
} 
?>

<!-- ======= Hero Section ======= -->
<section class="bg-bread">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1 class="" name="update_info">Update Info</h1>
                <h4 class=""><span name="home">Home</span> / <span name="update_info">Update Info</span></h4>
            </div>
        </div>
    </div>
</section>
<!-- ======= End Hero Section ======= -->

<section>
    <div class="container">
        <div class="row d-flex justify-content-center">
            
            
            <div class="col-md-6">
                <form action="#" method="post" role="form" id="updateForm">
                    <div class="row gy-4" id="viewDataSection">
                        
                        <div class="col-md-12 text-center">
                            <!--<img src="assets/images/icon-user-2.png" class="user-icon" alt="Icon User">-->
                            <svg class="user">
                                <use xlink:href="#user"></use>
                            </svg>
                        </div>
                        <div class="col-md-12 text-center">
                            <h3 class="my-2" id="client-name"></h3>
                        </div>
                        
                        <div class="col-lg-12 form-group">
                            <input type="text" name="first_name" id="first-name" class="form-control" placeholder="Enter your first name" value="<?php echo $user_first; ?>" required>
                        </div>
                        <div class="col-lg-12 form-group">
                            <input type="text" name="last_name" id="last-name" class="form-control" placeholder="Enter your last name" value="" required>
                        </div>
                        <div class="col-lg-12 form-group">
                            <input type="text" name="your_phone" id="phone" class="form-control" placeholder="Enter your phone number" value="" required>
                        </div>
                        <!--<div class="col-lg-12 form-group">-->
                        <!--    <input type="email" name="email" id="email" class="form-control" placeholder="Enter your email" value="" required disabled>-->
                        <!--</div>-->
                        <div class="col-lg-12 form-group">
                            <input type="text" name="your_address" id="address" class="form-control" placeholder="Enter your address" value="" required>
                        </div>
                    </div>
                    
                    <div class="row d-flex flex-row justify-content-center">
                        <div class="form-group col-md-12 text-center">
                            <p id="msg-box" name="msg-box"></p>
                        </div>
                        <div class="col-md-12 d-flex text-center justify-content-around mb-2">
                            <button class="shopBtn w-50" type="submit" name="update_info" id="updateBtn" >Update Info</button>
                        </div>
                    </div>
                    
                </form>
            </div>
        </div>
    </div>
</section>

<script>

let client_id = <?php echo $_SESSION['client_id']; ?>;

$(document).ready(function() {
    let urlClient = '<?php echo $path_api; ?>client/client_info.php';
    
    $.ajax({
        url: urlClient,
        type: 'POST',
        data: JSON.stringify({
            client_id: client_id
        }),
        contentType: 'application/json',
        success: function(response) {
            // console.log(response);
            if (response.success) {
                $('#client-name').text(response.first_name + ' ' + response.last_name);
                $('#first-name').val(response.first_name);
                $('#last-name').val(response.last_name);
                $('#phone').val(response.phone_number);
                $('#address').val(response.address);
            } else {
                console.log(response.message);
            }
        },
        error: function(xhr, status, error) {
            $('#msg-box').html('An error occurred. Please try again later.');
        }
    });
});
</script>

<script>
$(document).ready(function() {
    
    let urlUpdate = '<?php echo $path_api; ?>client/update_client.php';

    $('#updateForm').on('submit', function(e) {
        e.preventDefault();
        updateClient();
    });
    
    function updateClient(){
        let firstName = $('#first-name').val().trim();
        let lastName = $('#last-name').val().trim();
        let phone = $('#phone').val().trim();
        let address = $('#address').val().trim();

        // Validate form inputs
        if (firstName.length < 3) {
            $('#msg-box').html("Please insert a valid first name.");
            return;
        }
        if (lastName.length < 3) {
            $('#msg-box').html("Please insert a valid last name.");
            return;
        }
        if (phone === '' || !/^\d+$/.test(phone)) {
            $('#msg-box').html("Please insert a valid phone number.");
            return;
        }
        // if (address.length < 5) {
        //     $('#msg-box').html("Please insert a valid address.");
        //     return;
        // }

        $('#msg-box').html("Please wait...");
        
        // console.log("urlUpdate: " + urlUpdate);
        
        $.ajax({
            url: urlUpdate,
            type: 'POST',
            data: JSON.stringify({
                client_id: client_id,
                first_name: firstName,
                last_name: lastName,
                phone_number: phone,
                address: address
            }),
            contentType: 'application/json',
            success: function(response) {
                // console.log(response);
                if (response.success) {
                    $('#msg-box').html(response.message);
                    window.location.href = 'index.php?p=profile';
                } else {
                    // console.log(response.message);
                    $('#msg-box').html(response.message);
                }
            },
            error: function(xhr, status, error) {
                $('#msg-box').html('An error occurred. Please try again later.');
            }
        });
    }
    
});
</script>