<?php
if (isset($_SESSION['client_id'])) {
    echo '<script>
            window.location.href = "index.php?p=profile";
          </script>';
}
?>

<!-- ======= Hero Section ======= -->
<section class="bg-bread">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1 class="" name="login">Login</h1>
                <h4 class=""><span name="home">Home</span> / <span name="login">Login</span></h4>
            </div>
        </div>
    </div>
</section>
<!-- End Hero Section -->

<section class="position-relative">
    
    <div class="container">
        <div class="row d-flex justify-content-center text-center">
            <div class="col-md-6">
                <form action="#" method="post" role="form">
                    <div class="row gy-4 d-flex justify-content-center">
                        <div class="col-md-10">
                            <h3 class="section-title mb-2" name="login">Login</h3>
                            <p name="login_text">
                                To access your account, please enter your login details in the fields below. This will allow you to manage your profile, track your orders, and enjoy all the benefits of our website.
                            </p>
                        </div>
                        <div class="col-lg-12 form-group">
                            <input type="email" name="your_email" id="email" class="form-control" placeholder="Email" required>
                        </div>
                        <div class="col-lg-12 form-group position-relative">
                            <input type="password" id="password" name="your_password" class="form-control" placeholder="Password" required>
                            <button class="showBtn" type="button" id="show-password">
                                <i class="fa fa-eye-slash"></i>
                            </button>
                        </div>
                        <div class="m-0">
                            <p id="msg-box" name="msg-box" class="m-0 mt-2"></p>
                        </div>
                        <div class="col-md-12">
                            <button class="shopBtn mt-2" type="button" name="login" id="loginBtn">Login</button>
                            <p class="m-0 my-2"><a href="index.php?p=forget_password" class="extralink" name="forgot_password">Forgot password</a>?</p>
                            <p class="m-0"><span name="dont_have_account">Don't have an account? </span> <a href="index.php?p=create_user" class="extralink" name="create_one"> Create one.</a></p>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>

<script>
    document.getElementById('show-password').addEventListener('click', function() {
        var passwordInput = document.getElementById('password');
        var eyeIcon = this.querySelector('i');

        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            eyeIcon.classList.remove('fa-eye-slash');
            eyeIcon.classList.add('fa-eye');
        } else {
            passwordInput.type = 'password';
            eyeIcon.classList.remove('fa-eye');
            eyeIcon.classList.add('fa-eye-slash');
        }
    });
</script>

<script>
/*-------------------------------------------
            Login Form
-------------------------------------------*/ 

// $(document).ready(function() {
//     var client_id;
//     var client_name;
            
//     if ($('#loginBtn').length) {
//         $('#loginBtn').on('click', function(event) {
//             event.preventDefault();

//             let email = $('#email').val().trim();
//             let password = $('#password').val().trim();

//             let isValid = true;
//             let msg = '';

//             const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
//             if (!emailPattern.test(email)) {
//                 isValid = false;
//                 msg += 'Please enter a valid email address.<br>';
//             }

//             if (password.length < 6) {
//                 isValid = false;
//                 msg += 'Password should be at least 6 characters long.<br>';
//             }

//             if (!isValid) {
//                 $('#msg-box').html(msg);
//                 return;
//             }
            
//             $('#msg-box').html("Please Wait...");
            
//             let urlLog = '<?php echo $path_api; ?>client/login.php';
            
//             let postData = JSON.stringify({
//                 email: email,
//                 password: password,
//             });

//             console.log("urlLog: " + urlLog);

//             $.ajax({
//                 url: urlLog,
//                 type: 'POST',
//                 data: postData,
//                 contentType: 'application/json',
//                 success: function(response) {
//                     console.log(response);
//                     $('#msg-box').html(response.message);
                    
//                     if (response.success) {
//                         $('#msg-box').html(response.message);
//                         // window.location.href = 'index.php?p=profile';
//                     } else {
//                         // Show error message
//                         $('#msg-box').html(response.message);
//                     }
//                 },
//                 error: function(xhr, status, error) {
//                     $('#msg-box').html('An error occurred. Please try again later.');
//                 }
//             });
//         });
//     }
// });


$(document).ready(function () {
    var client_id;
    var client_name;

    if ($('#loginBtn').length) {
        $('#loginBtn').on('click', function (event) {
            event.preventDefault();

            let email = $('#email').val().trim();
            let password = $('#password').val().trim();

            const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (!emailPattern.test(email)) {
                $('#msg-box').html(
                    language === 'arabic'
                        ? 'يرجى إدخال عنوان بريد إلكتروني صالح.'
                        : 'Please enter a valid email address.'
                );
                return;
            }

            if (password.length < 6) {
                $('#msg-box').html(
                    language === 'arabic'
                        ? 'يجب أن تكون كلمة المرور مكونة من 6 أحرف على الأقل.'
                        : 'Password should be at least 6 characters long.'
                );
                return;
            }

            $('#msg-box').html(language === 'arabic' ? 'يرجى الانتظار...' : 'Please Wait...');

            let urlLog = '<?php echo $path_api; ?>client/login.php';

            let postData = JSON.stringify({
                email: email,
                password: password,
            });

            console.log('urlLog: ' + urlLog);

            $.ajax({
                url: urlLog,
                type: 'POST',
                data: postData,
                contentType: 'application/json',
                success: function (response) {
                    console.log(response);
                    $('#msg-box').html(response.message);

                    if (response.success) {
                        $('#msg-box').html(language === 'arabic' ? 'جارٍ إعادة التوجيه...' : 'Redirecting...');
                        client_id = response.client_id;
                        client_name = response.name;

                        // AJAX request to store these values in session
                        $.ajax({
                            url: 'profile/store_session_client.php',
                            type: 'POST',
                            data: JSON.stringify({
                                client_id: client_id,
                                client_name: client_name,
                            }),
                            contentType: 'application/json',
                            success: function (sessionResponse) {
                                console.log(sessionResponse);
                                $('#msg-box').html(sessionResponse.message);
                                window.location.href = 'index.php?p=profile';
                            },
                            error: function (xhr, status, error) {
                                $('#msg-box').html(
                                    language === 'arabic'
                                        ? 'حدث خطأ أثناء تخزين الجلسة. يرجى المحاولة مرة أخرى لاحقًا.'
                                        : 'An error occurred while storing session. Please try again later.'
                                );
                            },
                        });
                    } else {
                        $('#msg-box').html(response.message);
                    }
                },
                error: function (xhr, status, error) {
                    $('#msg-box').html(
                        language === 'arabic'
                            ? 'حدث خطأ. يرجى المحاولة مرة أخرى لاحقًا.'
                            : 'An error occurred. Please try again later.'
                    );
                },
            });
        });
    }
});

</script>
