<?php 

if (isset($_GET['id'])) {
    $product_id = intval($_GET['id']);
} else {
    echo '<script>window.location.href = "index.php?p=home";</script>';
    exit;
}

?>

<!-- ======= Hero Section ======= -->
<section class="bg-bread">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1 class="" name="product">Product</h1>
                <h4 class=""><span name="home">Home</span> / <span name="product">Product</span></h4>
            </div>
        </div>
    </div>
</section>
<!-- ====== End Hero Section ====== -->

<!-- ======= Single Product ======= -->
<section class="position-relative">
    <div class="container">
        <?php 
            // if ($row = $result->fetch_assoc()) { 
        ?>
        <div class="row justify-content-between gy-4">
            <div class="col-md-5">
                
                <img id="product-image" src="" alt="" class="img-fluid">
                
                <ul id="image-list" class="image-list">
                    
                </ul>
                
            </div>
            <!-- End Info Item -->
            <div class="col-md-6 mt-4">
                <h2 class="section-title" id="product-title">

                </h2>
                <div class="d-flex align-items-center">
                    <div class="d-flex flex-row" id="product-price">
                        
                    </div>
                    <!--<span>-->
                    <!--    (Per Piece)-->
                    <!--</span>-->
                </div>
                
                <div class="d-flex flex-row align-items-center">
                    <div class="quantity-control">
                        <!--<button type="button" class="qty-btn minus" onclick="changeQuantity(-1, 'qty_<?php echo htmlspecialchars($product_id); ?>')">-</button>-->
                        <!--<input type="text" id="quantity" class="input-text qty input_quantity" value="1" min="1" id="qty_<?php echo htmlspecialchars($product_id); ?>" readonly>-->
                        <!--<button type="button" class="qty-btn plus" onclick="changeQuantity(1, 'qty_<?php echo htmlspecialchars($product_id); ?>')">+</button>-->
                        <input type="number" id="quantity" name="quantity" value="1" min="1" class="form-control">
                    </div>
                    <!--<button id="addCart" name="add_to_cart" class="btn btn-dark rounded" type="button" onclick="update_cart('add', <?php echo htmlspecialchars($product_id); ?>);" data-toggle="modal" data-target="#exampleModal">Add to cart</button>-->
                    <div id="add_cart_div">
                        
                    </div>
                </div>
                
                <p class="mt-2" id="product-description">
                    
                </p>
                
            </div>
            <!-- End Info Item -->
        </div>
        
    </div>
</section>
<!-- End Product Section -->


<!-- Modal Structure -->
<div id="image-modal" style="display: none;">
  <div class="image-modal-content">
    <span id="close-modal">&times;</span>
    <img id="modal-image" src="" alt="Product Image">
  </div>
</div>

<script>
$(document).ready(function() {
  fetchItem();
  setupImageModal();
});

function setupImageModal() {
  $('#product-image').on('click', function() {
    const imgSrc = $(this).attr('src');
    $('#modal-image').attr('src', imgSrc);
    $('#image-modal').fadeIn();
  });

  // Close modal when clicking on the close button or outside the image
  $('#close-modal, #image-modal').on('click', function() {
    $('#image-modal').fadeOut();
  });

  // Prevent closing the modal when clicking directly on the modal image content
  $('.image-modal-content').on('click', function(event) {
    event.stopPropagation();
  });
}

function setupImageClick() {
  $('#image-list').on('click', 'li img', function() {
    const newSrc = $(this).attr('src');
    $('#product-image').attr('src', newSrc);
  });
}

function fetchItem() {
  const urlParams = new URLSearchParams(window.location.search);
  const productId = <?php echo $product_id; ?>;

  if (productId) {
    const apiUrl = `<?php echo $path_api; ?>item.php?id=${productId}&language=${language}`;
    
    console.log("apiUrl: " + apiUrl);

    $.ajax({
      url: apiUrl,
      type: 'GET',
      dataType: 'json',
      success: function(data) {
        if (data.success && data.objects.length > 0) {
          const product = data.objects[0];
          
          
          $('#add_cart_div').html(`<button id="addCart" name="add_to_cart" class="btn btn-dark rounded" type="button" onclick="update_cart('add', <?php echo htmlspecialchars($product_id); ?>, '${product.name}');" data-toggle="modal" data-target="#exampleModal">Add to cart</button>`);

          // Update product details
          $('#product-title').text(product.name);
          $('#product-description').text(product.description);

          // GET index 0 of the JSON
        //   const images = JSON.parse(product.image);
        //   if (images.length > 0) {
        //     $('#product-image').attr('src', images[0]);
        //   }
        
            $('#product-image').attr('src', product.image[0]);

          // Display all images in #image-list
        //   const imageList = $('#image-list');
        //   imageList.empty(); // Clear any existing images
        //   images.forEach((imgSrc) => {
        //     imageList.append(`<li><img src="${imgSrc}" alt="${product.name} image" class="img-fluid"></li>`);
        //   });
        
        // Display all images in #image-list
        const imageList = $('#image-list');
        imageList.empty(); // Clear any existing images

        // Loop over each image in the product.image object
        Object.keys(product.image).forEach((key) => {
          const imgSrc = product.image[key];
          imageList.append(`<li><img src="${imgSrc}" alt="${product.name} image" class="img-fluid"></li>`);
        });

          setupImageClick(); // This guy is just for changing the main picture upon clicking

          // Displaying price with or without discount
          if (product.price_discount && product.price_discount > 0) {
            $('#product-price').html(`<h4><?php echo $currency; ?> ${product.price_discount}</h4><del class="mx-2"><?php echo $currency; ?> ${product.price}</del>`);
          } else {
            $('#product-price').html(`<h4><?php echo $currency; ?> ${product.price}</h4>`);
          }
        }
      },
      error: function(xhr, status, error) {
        console.error('Error fetching product details:', error);
      }
    });
  } else {
    console.error('Product ID not found in the URL.');
  }
}


</script>
