<?php 

if (isset($_GET['id'])) {
    $product_id = intval($_GET['id']);
} else {
    echo '<script>window.location.href = "index.php?p=home";</script>';
    exit;
}

?>

<!-- ======= Hero Section ======= -->
<section class="bg-bread">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1 class="" name="product">Product</h1>
                <h4 class=""><span name="home">Home</span> / <span name="product">Product</span></h4>
            </div>
        </div>
    </div>
</section>
<!-- ====== End Hero Section ====== -->

<!-- ======= Single Product ======= -->
<section class="position-relative">
    <div class="container">
        <?php 
            // if ($row = $result->fetch_assoc()) { 
        ?>
        <div class="row justify-content-between gy-4">
            <div class="col-md-5">
                
                <img id="product-image" src="" alt="" class="img-fluid mb-4">
                
                <ul id="image-list" class="image-list">
                    
                </ul>
                
            </div>
            <!-- End Info Item -->
            <div class="col-md-6 mt-4">
                <h2 class="section-title" id="product-title">

                </h2>
                <div class="d-flex align-items-center">
                    <div class="d-flex flex-row" id="product-price">
                        
                    </div>
                    <!--<span>-->
                    <!--    (Per Piece)-->
                    <!--</span>-->
                </div>
                
                <div id="product_out">
                    
                </div>
                
                <p class="mt-2" id="product-description">
                    
                </p>
                
                <div class="row mb-2" id="product-options">
                    
                    <!--<div class="col-md-6" id="product-size">-->
                        
                    <!--</div>-->
                    
                    <!--<div class="col-md-6" id="product-color">-->
                        
                    <!--</div>-->
                    
                    
                    
                </div>
                
                <div class="col-12">
                    <p id="cart-box"></p>
                </div>
                
                <div class="d-flex flex-row align-items-center">
                    <div class="quantity-control">
                        <!--<button type="button" class="qty-btn minus" onclick="changeQuantity(-1, 'qty_<?php echo htmlspecialchars($product_id); ?>')">-</button>-->
                        <!--<input type="text" id="quantity" class="input-text qty input_quantity" value="1" min="1" id="qty_<?php echo htmlspecialchars($product_id); ?>" readonly>-->
                        <!--<button type="button" class="qty-btn plus" onclick="changeQuantity(1, 'qty_<?php echo htmlspecialchars($product_id); ?>')">+</button>-->
                        <input type="number" id="quantity" name="quantity" value="1" min="1" class="form-control">
                    </div>
                    <!--<button id="addCart" name="add_to_cart" class="btn btn-dark rounded" type="button" onclick="update_cart('add', <?php echo htmlspecialchars($product_id); ?>);" data-toggle="modal" data-target="#exampleModal">Add to cart</button>-->
                    <div id="add_cart_div">
                        
                    </div>
                </div>
                
            </div>
            <!-- End Info Item -->
        </div>
        
    </div>
</section>
<!-- End Product Section -->


<!-- Modal Structure -->
<div id="image-modal" style="display: none;">
  <div class="image-modal-content">
    <span id="close-modal">&times;</span>
    <img id="modal-image" src="" alt="Product Image">
  </div>
</div>

<script>
$(document).ready(function() {
  fetchItem();
  setupImageModal();
});

// function fetchItem() {
//   const urlParams = new URLSearchParams(window.location.search);
//   const productId = <?php echo $product_id; ?>;

//   if (productId) {
//     const apiUrl = `<?php echo $path_api; ?>item.php?id=${productId}&language=${language}`;
    
//     console.log("apiUrl: " + apiUrl);

//     $.ajax({
//       url: apiUrl,
//       type: 'GET',
//       dataType: 'json',
//       success: function(data) {
//         if (data.success && data.objects.length > 0) {
//           const product = data.objects[0];
          
//           if (product.out_of_stock == 1){
//               $('#add_cart_div').html(`<button id="addCart" name="add_to_cart" class="btn btn-dark rounded" type="button" disabled >Add to cart</button>`);
//               $('#product_out').html(`<h6 name="product_out" class="product_out">This product is out of stock</h6>`);
//           } else {
//               $('#add_cart_div').html(`<button id="addCart" name="add_to_cart" class="btn btn-dark rounded" type="button" onclick="update_cart('add', <?php echo htmlspecialchars($product_id); ?>, '${product.name}');" data-toggle="modal" data-target="#exampleModal">Add to cart</button>`);
//           }
          
//           // Update product details
//           $('#product-title').text(product.name);
//           $('#product-description').text($('<div>').html(product.description).text());
//           $('#product-image').attr('src', product.image[0]);

//           // Display all images in #image-list
//           const imageList = $('#image-list');
//           imageList.empty();
//           Object.keys(product.image).forEach((key) => {
//             const imgSrc = product.image[key];
//             imageList.append(`<li><img src="${imgSrc}" alt="${product.name} image" class="img-fluid"></li>`);
//           });

//           setupImageClick(); // Set up main image click functionality

//           // Display price with or without discount
//           updatePrice(product.price, product.discount);

//           // Prepare #product-options content
//           const productOptions = $('#product-options');
//           productOptions.empty();

//           // Generate sizes select box
//           if (product.size && product.size.length > 0) {
//             const sizeDiv = $('<div class="col-md-6"></div>');
//             const sizeSelect = $('<select class="form-select"></select>')
//               .attr('id', 'select-size')
//               .append('<option name="select_size" value="" disabled selected>Select Size</option>');

//             product.size.forEach((size) => {
//               sizeSelect.append(`<option value="${size.id}" data-price="${size.price}" data-discount="${size.discount}">${size.name}</option>`);
//             });

//             sizeDiv.append('<label name="size" for="select-size">Size:</label>');
//             sizeDiv.append(sizeSelect);

//             productOptions.append(sizeDiv);

//             // Update price on size change
//             $('#select-size').on('change', function () {
//               const selectedOption = $(this).find(':selected');
//               const newPrice = selectedOption.data('price');
//               let newDiscount = selectedOption.data('discount');

//               // Fallback to the main item's discount if size discount is 0
//               if (newDiscount === 0) {
//                 newDiscount = product.discount;
//               }

//               updatePrice(newPrice, newDiscount);
//             });
//           }

//           // Generate colors select box
//           if (product.color && product.color.length > 0) {
//             const colorDiv = $('<div class="col-md-6"></div>');
//             const colorSelect = $('<select class="form-select"></select>')
//               .attr('id', 'select-color')
//               .append('<option name="select_color" value="" disabled selected>Select Color</option>');

//             product.color.forEach((color) => {
//               colorSelect.append(`<option value="${color.id}">${color.name}</option>`);
//             });

//             colorDiv.append('<label name="color" for="select-color">Color:</label>');
//             colorDiv.append(colorSelect);

//             productOptions.append(colorDiv);
//           }
//         }
//       },
//       error: function(xhr, status, error) {
//         console.error('Error fetching product details:', error);
//       }
//     });
//   } else {
//     console.error('Product ID not found in the URL.');
//   }
// }

function fetchItem() {
  const urlParams = new URLSearchParams(window.location.search);
  const productId = <?php echo $product_id; ?>;

  if (productId) {
    const apiUrl = `<?php echo $path_api; ?>item.php?id=${productId}&language=${language}`;
    
    console.log("apiUrl: " + apiUrl);

    $.ajax({
      url: apiUrl,
      type: 'GET',
      dataType: 'json',
      success: function(data) {
        if (data.success && data.objects.length > 0) {
          const product = data.objects[0];
          
          if (product.out_of_stock == 1) {
              $('#add_cart_div').html(`<button id="addCart" name="add_to_cart" class="btn btn-dark rounded" type="button" disabled >Add to cart</button>`);
              $('#product_out').html(`<h6 name="product_out" class="product_out">This product is out of stock</h6>`);
          } else {
              $('#add_cart_div').html(`<button id="addCart" name="add_to_cart" class="btn btn-dark rounded" type="button" onclick="update_cart('add', <?php echo htmlspecialchars($product_id); ?>, '${product.name}');" data-toggle="modal" data-target="#exampleModal">Add to cart</button>`);
          }

          // Update product details
          $('#product-title').text(product.name);
          $('#product-description').text($('<div>').html(product.description).text());
          $('#product-image').attr('src', product.image[0]);

          // Display all images in #image-list
          const imageList = $('#image-list');
          imageList.empty();
          Object.keys(product.image).forEach((key) => {
            const imgSrc = product.image[key];
            imageList.append(`<li><img src="${imgSrc}" alt="${product.name} image" class="img-fluid"></li>`);
          });

          setupImageClick(); // Set up main image click functionality

          // Display price with or without discount
          updatePrice(product.price, product.discount);

          // Prepare #product-options content
          const productOptions = $('#product-options');
          productOptions.empty();

          // Generate sizes select box
          if (product.size && product.size.length > 0) {
            const sizeDiv = $('<div class="col-md-6"></div>');
            const sizeSelect = $('<select class="form-select"></select>')
              .attr('id', 'select-size')
              .append('<option name="select_size" value="" disabled selected>Select Size</option>');

            product.size.forEach((size) => {
              const option = size.out_of_stock == 1
                ? `<option value="${size.id}" disabled><del>${size.name}</del></option>`
                : `<option value="${size.id}" data-price="${size.price}" data-discount="${size.discount}">${size.name}</option>`;
              sizeSelect.append(option);
            });

            sizeDiv.append('<label name="size" for="select-size">Size:</label>');
            sizeDiv.append(sizeSelect);

            productOptions.append(sizeDiv);

            // Update price on size change
            $('#select-size').on('change', function () {
              const selectedOption = $(this).find(':selected');
              const newPrice = selectedOption.data('price');
              let newDiscount = selectedOption.data('discount');

              // Fallback to the main item's discount if size discount is 0
              if (newDiscount === 0) {
                newDiscount = product.discount;
              }

              updatePrice(newPrice, newDiscount);
            });
          }

          // Generate colors select box
          if (product.color && product.color.length > 0) {
            const colorDiv = $('<div class="col-md-6"></div>');
            const colorSelect = $('<select class="form-select"></select>')
              .attr('id', 'select-color')
              .append('<option name="select_color" value="" disabled selected>Select Color</option>');

            product.color.forEach((color) => {
              const option = color.out_of_stock == 1
                ? `<option value="${color.id}" disabled><del>${color.name}</del></option>`
                : `<option value="${color.id}">${color.name}</option>`;
              colorSelect.append(option);
            });

            colorDiv.append('<label name="color" for="select-color">Color:</label>');
            colorDiv.append(colorSelect);

            productOptions.append(colorDiv);
          }
        }
      },
      error: function(xhr, status, error) {
        console.error('Error fetching product details:', error);
      }
    });
  } else {
    console.error('Product ID not found in the URL.');
  }
}

function setupImageModal() {
  $('#product-image').on('click', function() {
    const imgSrc = $(this).attr('src');
    $('#modal-image').attr('src', imgSrc);
    $('#image-modal').fadeIn();
  });

  // Close modal when clicking on the close button or outside the image
  $('#close-modal, #image-modal').on('click', function() {
    $('#image-modal').fadeOut();
  });

  // Prevent closing the modal when clicking directly on the modal image content
  $('.image-modal-content').on('click', function(event) {
    event.stopPropagation();
  });
}

function setupImageClick() {
  $('#image-list').on('click', 'li img', function() {
    const newSrc = $(this).attr('src');
    $('#product-image').attr('src', newSrc);
  });
}

function updatePrice(price, discount) {

  price = parseFloat(price) || 0;
  discount = parseFloat(discount) || 0;
  
//   console.log("price: " + price);
//   console.log("discount: " + discount);

  let discountedPrice = price;

  if (discount > 0) {
    discountedPrice = price - (price * discount / 100);
    $('#product-price').html(`
      <h4><?php echo $currency; ?> ${discountedPrice.toFixed(2)}</h4>
      <del class="mx-2"><?php echo $currency; ?> ${price.toFixed(2)}</del>
    `);
  } else {
    $('#product-price').html(`<h4><?php echo $currency; ?> ${price.toFixed(2)}</h4>`);
  }
}

</script>
