<?php
if (isset($_GET['discount'])) {
    $discount = intval($_GET['discount']);
} else {
    $discount = 0;
}
if (isset($_GET['category_id'])) {
    $category_id = intval($_GET['category_id']);
} else {
    $category_id = NULL;
}
?>

<!-- ======= Hero Section ======= -->
<section class="bg-bread">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1 class="" name="products">Products</h1>
                <h4 class=""><span name="home">Home</span> / <span name="products">Products</span></h4>
            </div>
        </div>
    </div>
</section>
<!-- ====== End Hero Section ====== -->

<section>
    <div class="container">
        <div class="row">

            <!-- Filter Start-->
            <div class="col-md-3 mb-4">
                <form class="filterForm" id="filterForm">
                    <h2 name="item_filter">
                        Item Filter
                    </h2>
                    <hr>
                    
                    <!-- Sort Price -->
                    <h6 name="sort_price">Sort By Price</h6>
                    <ul>
                        
                        <li><input type="radio" name="sort" value="price_asc" id="low_high">
                            <span name="low_high">Low to High</span>
                        </li>
                        <li><input type="radio" name="sort" value="price_desc" id="high_low">
                            <span name="high_low">High to Low</span>
                        </li>
                    </ul>
                    <!-- Price End -->
                    
                    <!-- Sort Date -->
                    <h6 name="sort_date">Sort By Date</h6>
                    <ul>
                        
                        <li><input type="radio" name="sort" value="date_asc" id="old_new">
                            <span name="old_new">Oldest to Newest</span>
                        </li>
                        <li><input type="radio" name="sort" value="date_desc" id="new_old">
                            <span name="new_old">Newest to Oldest</span>
                        </li>
                    </ul>
                    <!-- Date End -->
                    
                    <!-- Sort Popularity -->
                    <h6 name="sort_popularity">Sort By Popularity</h6>
                    <ul>
                        
                        <li><input type="radio" name="sort" value="trend" id="trending"> 
                            <span name="trending">Trending</span>
                        </li>
                        <!--<li><input type="radio" name="sort" value="best"> Best Seller</li>-->
                        <li><input type="radio" name="sort" value="discount" id="offers" <?php if ($discount == '1') {echo 'checked';} ?>>
                            <span name="offers">Offers</span>
                        </li>
                    </ul>
                    <!-- Popularity End -->
                    
                    <!-- Sort Category -->
                    <h6 name="sort_category">Sort By Category</h6>
                    <ul class="category-list" id="category-list">
                        
                    </ul>
                    <!-- Category End -->
                    
                    <button id="filter-btn" name="filter" class="shopBtn mb-2" type="submit">Filter</button>
                    <a href="index.php?p=products" class="shopBtn mb-2" name="clear_filter">Clear Filter</a>
                </form>
            </div>
            <!-- Filter END-->

            <!-- Products Start-->
            <div class="col-md-9">
                <div class="row" id="product-container">
                    
                </div>
            </div>
            <!-- Products END-->

        </div>
        
        <!-- Pagination Start -->
        <div class="row mt-4">
            <div class="col-md-12">
                <div id="pagination-container" class="pagination">
                    
                </div>
            </div>
        </div>
        <!-- Pagination Start -->
        
    </div>
</section>

<script>

let categoryAdded = false; // to make it added only one time

$(document).ready(function() {
    fetchCategory();
    fetchItems(1);
    
    $('#filterForm').on('submit', function(e) {
        e.preventDefault();
        fetchItems();
    });
    
});

// function fetchCategory() {
//   $.ajax({
//     url: '<?php echo $path_api; ?>category.php',
//     type: 'GET',
//     dataType: 'json',
//     success: function(data) {
//       if (data.success) {
//         const categoryList = $('#category-list');
//         let categoryHTML = '';

//         $.each(data.objects, function(index, category) {
//           categoryHTML += `
//             <li><input type="checkbox" name="sort_checkbox" value="${category.id}"> ${category.name}</li>
//             `;
//         });
//         categoryList.html(categoryHTML);
//       }
//     },
//     error: function(xhr, status, error) {
//       console.error('Error fetching products:', error);
//     }
//   });
// }
function fetchCategory() {
  const categoryIdFromUrl = '<?php echo $category_id; ?>';

  $.ajax({
    url: '<?php echo $path_api; ?>category.php?language=' + language,
    type: 'GET',
    dataType: 'json',
    success: function(data) {
      if (data.success) {
        const categoryList = $('#category-list');
        let categoryHTML = '';

        $.each(data.objects, function(index, category) {
          const isChecked = categoryIdFromUrl == category.id ? 'checked' : '';

          categoryHTML += `
            <li><input type="checkbox" name="sort_checkbox" value="${category.id}" ${isChecked}> ${category.name}</li>
            `;
        });

        categoryList.html(categoryHTML);

        if (categoryIdFromUrl) {
          fetchItems(1);
        }
      }
    },
    error: function(xhr, status, error) {
      console.error('Error fetching categories:', error);
    }
  });
}

// function fetchItems(page = 1) {
//     const trendSelected = $('input[name="sort"]:checked').val() === 'trend' ? '1' : '';
//     const discountVal = $('input[name="sort"]:checked').val() === 'discount' ? '1' : '';
//     const priceSort = $('input[name="sort"]:checked').val();
//     const dateSort = $('input[name="sort"]:checked').val();
//     // const discountVal = <?php echo $discount ?>;
//     const categories = [];
//     const limit = '&limit=15';

//     $('input[name="sort_checkbox"]:checked').each(function() {
//         categories.push($(this).val());
//     });

//     let urlItems = '<?php echo $path_api; ?>item.php?page=' + page + limit;

//     if (trendSelected) {
//         urlItems += `&is_trending=1`;
//     }
    
//     if (discountVal) {
//         urlItems += `&discount=1`;
//     }

//     if (categories.length > 0) {
//         urlItems += `&category_id=${categories.join(',')}`;
//     }

//     if (priceSort) {
//         urlItems += `&sort_price=${priceSort}`;
//     }

//     if (dateSort) {
//         urlItems += `&sort_date=${dateSort}`;
//     }

//     urlItems = urlItems.slice(-1) === '&' ? urlItems.slice(0, -1) : urlItems;
    
//     console.log("urlItems: " + urlItems);

//     $.ajax({
//         url: urlItems,
//         type: 'GET',
//         dataType: 'json',
//         success: function(data) {
//             const $productContainer = $('#product-container');
//             $productContainer.empty();  // Clear the container before updating
//             let productHTML = '';

//             if (data.success && data.objects.length > 0) {
//                 $.each(data.objects, function(index, product) {
                    
//                     // Check if price_discount is null, empty, or 0
//                     let priceHTML;
//                     if (!product.price_discount || product.price_discount == 0) {
//                         priceHTML = `<span class="item-price text-primary"><?php echo $currency; ?> ${product.price}</span>`;
//                     } else {
//                         priceHTML = `
//                             <span class="item-price text-primary"><?php echo $currency; ?> ${product.price_discount}</span>
//                             <del class="item-price"><?php echo $currency; ?> ${product.price}</del>
//                         `;
//                     }
                    
//                     productHTML += `
//                         <div class="col-lg-4 col-md-6 mb-4">
//                           <div class="product-card">
//                             <a class="image-holder" href="index.php?p=product&id=${product.id}">
//                               <img src="${product.image}" alt="${product.name}" class="img-fluid">
//                             </a>
//                             <div class="">
                              
//                             </div>
//                             <div class="cart-detail pb-2">
//                                 <h3 class="card-title text-uppercase">
//                                     <a href="index.php?p=product&id=${product.id}">${product.name}</a>
//                                 </h3>
//                                 ${priceHTML}
//                             </div>
//                           </div>
//                         </div>
//                     `;
//                 });

//                 $productContainer.html(productHTML);
//                 renderPagination(data.current_page, data.total_pages);
//             } else {
//                 // No items found, show a message to the user
//                 $productContainer.html('<p class="no-items-found">No items found matching your criteria.</p>');
//             }
//         },
//         error: function(xhr, status, error) {
//             console.error('Error fetching products:', error);
//         }
//     });
// }

function fetchItems(page = 1) {
    const trendSelected = $('input[name="sort"]:checked').val() === 'trend' ? '1' : '';
    const discountVal = $('input[name="sort"]:checked').val() === 'discount' ? '1' : '';
    const priceSort = $('input[name="sort"]:checked').val();
    const dateSort = $('input[name="sort"]:checked').val();
    const categories = [];
    const limit = '&limit=12';

    let categoryIdFromUrl = '<?php echo $category_id; ?>';

    if (categoryIdFromUrl && !categoryAdded) {
        categories.push(categoryIdFromUrl); // Add the category only once
        categoryAdded = true; // True so I added it one time
    }


    $('input[name="sort_checkbox"]:checked').each(function() {
        categories.push($(this).val());
    });

    let urlItems = '<?php echo $path_api; ?>item.php?page=' + page + limit;

    if (trendSelected) {
        urlItems += `&is_trending=1`;
    }

    if (discountVal) {
        urlItems += `&discount=1`;
    }

    if (categories.length > 0) {
        urlItems += `&category_id=${categories.join(',')}`;
    }

    if (priceSort) {
        urlItems += `&sort_price=${priceSort}`;
    }

    if (dateSort) {
        urlItems += `&sort_date=${dateSort}`;
    }

    urlItems = urlItems.slice(-1) === '&' ? urlItems.slice(0, -1) : urlItems;
    
    // we got it from the script
    urlItems +=`&language=`+language; 

    console.log("urlItems: " + urlItems);

    $.ajax({
    url: urlItems,
    type: 'GET',
    dataType: 'json',
    success: function(data) {
        console.log(data.objects);
        const $productContainer = $('#product-container');
        $productContainer.empty();
        let productHTML = '';

        if (data.success && data.objects.length > 0) {
            $.each(data.objects, function(index, product) {

                let priceHTML;
                if (!product.price_discount || product.price_discount == 0) {
                    priceHTML = `<span class="item-price text-primary"><?php echo $currency; ?> ${product.price}</span>`;
                } else {
                    priceHTML = `
                        <span class="item-price text-primary"><?php echo $currency; ?> ${product.price_discount}</span>
                        <del class="item-price"><?php echo $currency; ?> ${product.price}</del>
                    `;
                }

                let discountHTML = '';
                if (product.discount != 0) {
                    discountHTML = `<p class="product-discount"><span class="smol" name="discount">Discount</span>: %${product.discount}</p>`;
                }
                let stockHTML = '';
                if (product.out_of_stock == 1) {
                    stockHTML = `<p class="product-stock" name="out_of_stock">Out of stock</p>`;
                }
                
                // GET index 0 of the JSON
                // const images = JSON.parse(product.image);
                
                productHTML += `
                    <div class="col-xl-3 col-lg-4 col-md-6 mb-4">
                      <div class="product-card">
                        ${discountHTML}
                        ${stockHTML}
                        <a class="image-holder" href="index.php?p=product&id=${product.id}">
                          <img src="${product.image[0]}" alt="${product.name}" class="img-fluid">
                        </a>
                        <div class="">
                          
                        </div>
                        <div class="card-detail pb-2">
                            <h3 class="card-title text-uppercase">
                                <a href="index.php?p=product&id=${product.id}">${product.name}</a>
                            </h3>
                            ${priceHTML}
                        </div>
                      </div>
                    </div>
                `;
            });

            $productContainer.html(productHTML);
            renderPagination(data.current_page, data.total_pages);
        } else {
            $productContainer.html('<p class="no-items-found" name="no_items_criteria">No items found matching your criteria.</p>');
        }
    },
    error: function(xhr, status, error) {
        console.error('Error fetching products:', error);
    }
});

}



function renderPagination(currentPage, totalPages) {
    // console.log("Render Function...");
    // console.log("currentPage: " + currentPage);
    // console.log("totalPages: " + totalPages);
    const $paginationContainer = $('#pagination-container');
    let paginationHTML = '';

    // First Page and Previous Page
    if (currentPage > 1) {
        paginationHTML += `<li><a href="#" class="" data-page="1">First</a></li>`;
        paginationHTML += `<li><a href="#" class="" data-page="${currentPage - 1}">Previous</a></li>`;
    }

    // Numbered Pages
    for (let page = 1; page <= totalPages; page++) {
        if (page === currentPage) {
            paginationHTML += `<li class="pagiActive"><a href="#" class="" data-page="${page}">${page}</a></li>`;
        } else {
            paginationHTML += `<li><a href="#" class="" data-page="${page}">${page}</a></li>`;
        }
    }

    // Next and Last Page
    if (currentPage < totalPages) {
        paginationHTML += `<li><a href="#" class="" data-page="${currentPage + 1}">Next</a></li>`;
        paginationHTML += `<li><a href="#" class="" data-page="${totalPages}">Last</a></li>`;
    }

    $paginationContainer.html(paginationHTML);

    $paginationContainer.find('a').on('click', function(e) {
        e.preventDefault();
        const page = $(this).data('page');
        fetchItems(page);
    });
}

</script>