<?php
ini_set('display_errors', 1); // Enable error reporting
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'myfatoorah-library-2.2/MyfatoorahLoader.php';
include 'myfatoorah-library-2.2/MyfatoorahLibrary.php';

/* --------------------------- Configurations ------------------------------- */
$mfConfig = [
    'apiKey'      => 'rLtt6JWvbUHDDhsZnfpAhpYk4dxYDQkbcPTyGaKp2TYqQgG7FGZ5Th_WD53Oq8Ebz6A53njUoo1w3pjU1D4vs_ZMqFiz_j0urb_BH9Oq9VZoKFoJEDAbRZepGcQanImyYrry7Kt6MnMdgfG5jn4HngWoRdKduNNyP4kzcp3mRv7x00ahkm9LAK7ZRieg7k1PDAnBIOG3EyVSJ5kK4WLMvYr7sCwHbHcu4A5WwelxYK0GMJy37bNAarSJDFQsJ2ZvJjvMDmfWwDVFEVe_5tOomfVNt6bOg9mexbGjMrnHBnKnZR1vQbBtQieDlQepzTZMuQrSuKn-t5XZM7V6fCW7oP-uXGX-sMOajeX65JOf6XVpk29DP6ro8WTAflCDANC193yof8-f5_EYY-3hXhJj7RBXmizDpneEQDSaSz5sFk0sV5qPcARJ9zGG73vuGFyenjPPmtDtXtpx35A-BVcOSBYVIWe9kndG3nclfefjKEuZ3m4jL9Gg1h2JBvmXSMYiZtp9MR5I6pvbvylU_PP5xJFSjVTIz7IQSjcVGO41npnwIxRXNRxFOdIUHn0tjQ-7LwvEcTXyPsHXcMD8WtgBh-wxR8aKX7WPSsT1O8d8reb2aR7K3rkV3K82K_0OgawImEpwSvp9MNKynEAJQS6ZHe_J_l77652xwPNxMRTMASk1ZsJL',
    'vcCode'      => 'KWT',
    'isTest'      => true,
];

/* --------------------------- SendPayment Endpoint ------------------------- */
$invoiceValue = 50;
$customerName = 'John Doe';
$customerMobile = '+965123456789';
$customerEmail = 'customer@example.com';
$callBackUrl = 'https://example.com/callback.php';
$errorUrl = 'https://example.com/error.php';

// Parse the phone string
$phone = MyFatoorah::getPhone($customerMobile);

// Post Fields
$postFields = [
    'InvoiceValue'       => $invoiceValue,
    'CustomerName'       => $customerName,
    'NotificationOption' => 'ALL', // SMS, EML, LNK
    'MobileCountryCode'  => $phone[0],
    'CustomerMobile'     => $phone[1],
    'CustomerEmail'      => $customerEmail,
    'CallBackUrl'        => $callBackUrl,
    'ErrorUrl'           => $errorUrl,
    'Language'           => 'en', // or 'ar'
];

try {
    $mfObj = new MyFatoorahPayment($mfConfig);
    $data  = $mfObj->sendPayment($postFields);

    // Check if the response contains InvoiceId and InvoiceURL
    if(isset($data->InvoiceId) && isset($data->InvoiceURL)) {
        $invoiceId   = $data->InvoiceId;
        $paymentLink = $data->InvoiceURL;

        // Redirect to the payment link
        header("Location: $paymentLink");
        exit;
    } else {
        echo "Error: Payment link or Invoice ID not found.";
    }

    echo '<h3><u>SendPayment Response Data:</u></h3><pre>';
    print_r($data);
    echo '</pre>';
} catch (Exception $ex) {
    echo '<h3>Error:</h3>';
    echo $ex->getMessage();
    die;
}
?>
