let path_api = "https://amcserver.com/app/online_shop/api/v1/";

(function ($) {
  "use strict";

//   var searchPopup = function () {
//     // open search box
//     $("#header-nav").on("click", ".search-button", function (e) {
//       $(".search-popup").toggleClass("is-visible");
//     });

//     $("#header-nav").on("click", ".btn-close-search", function (e) {
//       $(".search-popup").toggleClass("is-visible");
//     });

//     $(".search-popup-trigger").on("click", function (b) {
//       b.preventDefault();
//       $(".search-popup").addClass("is-visible"),
//         setTimeout(function () {
//           $(".search-popup").find("#search-popup").focus();
//         }, 350);
//     }),
//       $(".search-popup").on("click", function (b) {
//         ($(b.target).is(".search-popup-close") ||
//           $(b.target).is(".search-popup-close svg") ||
//           $(b.target).is(".search-popup-close path") ||
//           $(b.target).is(".search-popup")) &&
//           (b.preventDefault(), $(this).removeClass("is-visible"));
//       }),
//       $(document).keyup(function (b) {
//         "27" === b.which && $(".search-popup").removeClass("is-visible");
//       });
//   };

var searchPopup = function () {
  // Open search box on search button click
  $("#header-nav").on("click", ".search-button", function (e) {
    $(".search-popup").toggleClass("is-visible");
  });

  // Close search box on close button click within header-nav
  $("#header-nav").on("click", ".btn-close-search", function (e) {
    $(".search-popup").toggleClass("is-visible");
  });

  // Open search popup and focus on input
  $(".search-popup-trigger").on("click", function (b) {
    b.preventDefault();
    $(".search-popup").addClass("is-visible");
    setTimeout(function () {
      $(".search-popup").find("#search-popup").focus();
    }, 350);
  });

  // Close search popup only when the #search-popup-close button is clicked
  $(".search-popup").on("click", "#search-popup-close", function (b) {
    b.preventDefault();
    $(".search-popup").removeClass("is-visible");
  });

  // Close popup on pressing the Escape key
  $(document).keyup(function (b) {
    if (b.which === 27) {
      $(".search-popup").removeClass("is-visible");
    }
  });
};


  var initProductQty = function () {
    $(".product-qty").each(function () {
      var $el_product = $(this);
      var quantity = 0;

      $el_product.find(".quantity-right-plus").click(function (e) {
        e.preventDefault();
        var quantity = parseInt($el_product.find("#quantity").val());
        $el_product.find("#quantity").val(quantity + 1);
      });

      $el_product.find(".quantity-left-minus").click(function (e) {
        e.preventDefault();
        var quantity = parseInt($el_product.find("#quantity").val());
        if (quantity > 0) {
          $el_product.find("#quantity").val(quantity - 1);
        }
      });
    });
  };

  $(document).ready(function () {
    searchPopup();
    initProductQty();

    var swiper = new Swiper(".main-swiper", {
      speed: 500,
      navigation: {
        nextEl: ".swiper-arrow-prev",
        prevEl: ".swiper-arrow-next",
      },
    });

    var swiper = new Swiper(".category-swiper", {
      slidesPerView: 5,
      spaceBetween: 10,
      pagination: {
        el: "#category-products .swiper-pagination",
        clickable: true,
      },
      breakpoints: {
        0: {
          slidesPerView: 2,
          spaceBetween: 20,
        },
        980: {
          slidesPerView: 5,
          spaceBetween: 20,
        },
      },
    });

    var swiper = new Swiper(".trend-swiper", {
      slidesPerView: 4,
      spaceBetween: 10,
      pagination: {
        el: "#trend-products .swiper-pagination",
        clickable: true,
      },
      breakpoints: {
        0: {
          slidesPerView: 2,
          spaceBetween: 20,
        },
        980: {
          slidesPerView: 4,
          spaceBetween: 20,
        },
      },
    });

    var swiper = new Swiper(".recent-swiper", {
      slidesPerView: 4,
      spaceBetween: 10,
      pagination: {
        el: "#recent-products .swiper-pagination",
        clickable: true,
      },
      breakpoints: {
        0: {
          slidesPerView: 2,
          spaceBetween: 20,
        },
        980: {
          slidesPerView: 4,
          spaceBetween: 20,
        },
      },
    });

    var swiper = new Swiper(".hot-swiper", {
      // effect: "coverflow",
      // coverflowEffect: {
      //     rotate: 0,
      //     stretch: 0,
      //     depth: 100,
      //     modifier: 1,
      //     slideShadows: true,
      // },
      slidesPerView: 4,
      spaceBetween: 10,
      pagination: {
        el: "#hot-products .swiper-pagination",
        clickable: true,
      },
      breakpoints: {
        0: {
          slidesPerView: 2,
          spaceBetween: 20,
        },
        980: {
          slidesPerView: 4,
          spaceBetween: 20,
        },
      },
    });

    var swiper = new Swiper(".testimonial-swiper", {
      loop: true,
      navigation: {
        nextEl: ".swiper-arrow-prev",
        prevEl: ".swiper-arrow-next",
      },
    });

    // Swiper Product
    var swiper_product = new Swiper(".swiper-product", {
      slidesPerView: 1,
      spaceBetween: 10,
      loop: true,
      grabCursor: true,
      navigation: {
        nextEl: ".swiper-button-next",
        prevEl: ".swiper-button-prev",
      },
      autoplay: {
        delay: 5000,
        disableOnInteraction: false,
      },
      speed: 2000,
    });
  }); // End of a document ready
})(jQuery);

/* ---------------------------------------------
        Send Sub Function
--------------------------------------------- */
$(document).on("click", "#newsBtn", function (e) {
  e.preventDefault();
  send_sub();
});

function send_sub() {
  var news_email = $("#newsletter").val();
  let urlSub = path_api + "subscribe.php";

  if (news_email === "") {
    $("#sub-box").html("Please fill out the field above.");
    return;
  }

  var pattern =
    /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
  if (!news_email.match(pattern)) {
    $("#sub-box").html(
      "Your email is incorrect, please use this format: email@example.com"
    );
    return;
  }

  $("#sub-box").html("Please wait...");

  $.ajax({
    url: urlSub,
    type: "POST",
    dataType: "json",
    contentType: "application/json",
    data: JSON.stringify({
      news_email: news_email,
    }),
    beforeSend: function () {
      $("#sub-box").html("Please wait, sending...");
    },
    success: function (response) {
    //   console.log(response);
      if (response.success) {
        $("#sub-box").html(response.message);
        $("#newsletter").val("");
      } else {
        $("#sub-box").html("" + response.message);
      }
    },
    error: function (xhr, status, error) {
      // console.error("AJAX Error:", xhr.responseText);
      // console.log("error: " + error);
      // console.log("status: " + status);
      $("#sub-box").html("An error occurred. Please try again later.");
    },
  });
}

/*---------------------------------------------------
                        Login
---------------------------------------------------*/

// if (document.getElementById('loginBtn')) {
// document.getElementById('loginBtn').addEventListener('click', function(event) {
//     event.preventDefault();

//     var email = $("#email").val();
//     var password = $("#password").val();
//     // var redirect = $("#redirect").val();

//     if (email !== "" && password !== "") {
//         var pattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

//         if (pattern.test(email)) {
//             $("#msg-box").html("Please Wait...");

//             $.post(
//                 "./profile/check_login.php",
//                 {
//                     your_email: email,
//                     your_password: password,
//                     // your_redirect: redirect,
//                     log: "true"
//                 },
//                 function(data, status) {
//                     $("#msg-box").html(data);
//                     $("#password").val("");
//                 }
//             ).fail(function() {
//                 $("#msg-box").html("An error occurred while sending the request.");
//             });
//         } else {
//             $("#msg-box").html("Your email is incorrect. Please use the format email@example.com.");
//         }
//     } else {
//         $("#msg-box").html("Please fill all the above fields.");
//     }
// });
// }

/*---------------------------------------------------
                        Create Client
---------------------------------------------------*/

// function send_reg() {
//     var first_name = $("#first-name").val().trim();
//     var last_name = $("#last-name").val().trim();
//     var email = $("#email").val().trim();
//     var password = $("#password").val().trim();
//     var phone = $("#phone").val().trim() || "0";
//     var address = $("#address").val().trim();

//     if (first_name.length <= 3) {
//         $("#msg-box").html("First name must be more than 3 characters.");
//         return false;
//     }
//     if (last_name.length <= 3) {
//         $("#msg-box").html("Last name must be more than 3 characters.");
//         return false;
//     }

//     var phone_pattern = /^[0-9]{7,}$/;
//     if (!phone.match(phone_pattern)) {
//         $("#msg-box").html("Phone number must be more than 6 digits and numbers only.");
//         return false;
//     }

//     var email_pattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
//     if (!email.match(email_pattern)) {
//         $("#msg-box").html("Your email is incorrect. Please use the format email@example.com.");
//         return false;
//     }

//     if (password.length <= 8) {
//         $("#msg-box").html("Password must be longer than 8 characters.");
//         return false;
//     }

//     if (first_name === "" || last_name === "" || phone === "" || email === "" || password === "" || address === "") {
//         $("#msg-box").html("Please fill all the above fields.");
//         return false;
//     }

//     $("#msg-box").html("");
//     $.post(
//         "./profile/register.php",
//         {
//             your_first_name: first_name,
//             your_last_name: last_name,
//             your_email: email,
//             your_password: password,
//             your_phone: phone,
//             your_address: address,
//             reg: "true"
//         },
//         function (data, status) {
//             $("#msg-box").html(data);
//             $("#first-name").val("");
//             $("#last-name").val("");
//             $("#email").val("");
//             $("#password").val("");
//             $("#phone").val("");
//             $("#address").val("");
//         }
//     ).fail(function () {
//         $("#msg-box").html("An error occurred while sending the request.");
//     });

//     return true;
// }

if (document.getElementById("regBtn")) {
  document.getElementById("regBtn").addEventListener("click", function (event) {
    event.preventDefault();

    var first_name = $("#first-name").val().trim();
    var last_name = $("#last-name").val().trim();
    var email = $("#email").val().trim();
    var password = $("#password").val().trim();
    var phone = $("#phone").val().trim() || "0";
    var address = $("#address").val().trim();

    if (first_name.length <= 3) {
      $("#msg-box").html("First name must be more than 3 characters.");
      return false;
    }
    if (last_name.length <= 3) {
      $("#msg-box").html("Last name must be more than 3 characters.");
      return false;
    }

    var phone_pattern = /^[0-9]{7,}$/;
    if (!phone.match(phone_pattern)) {
      $("#msg-box").html(
        "Phone number must be more than 6 digits and numbers only."
      );
      return false;
    }

    var email_pattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if (!email.match(email_pattern)) {
      $("#msg-box").html(
        "Your email is incorrect. Please use the format email@example.com."
      );
      return false;
    }

    if (password.length <= 8) {
      $("#msg-box").html("Password must be longer than 8 characters.");
      return false;
    }

    if (
      first_name === "" ||
      last_name === "" ||
      phone === "" ||
      email === "" ||
      password === "" ||
      address === ""
    ) {
      $("#msg-box").html("Please fill all the above fields.");
      return false;
    }

    $("#msg-box").html("Please Wait...");

    $.post(
      "./profile/register.php",
      {
        your_first_name: first_name,
        your_last_name: last_name,
        your_email: email,
        your_password: password,
        your_phone: phone,
        your_address: address,
        reg: "true",
      },
      function (data, status) {
        $("#msg-box").html(data);
        $("#first-name").val("");
        $("#last-name").val("");
        $("#email").val("");
        $("#password").val("");
        $("#phone").val("");
        $("#address").val("");
      }
    ).fail(function () {
      $("#msg-box").html("An error occurred while sending the request.");
    });

    return true;
  });
}

/*-------------------------------------------
        Send Contact Form
-------------------------------------------*/

if (document.getElementById("contactBtn")) {
  document
    .getElementById("contactBtn")
    .addEventListener("click", function (event) {
      event.preventDefault();

      let urlContact = path_api + "send_contact.php";

      // console.log("urlContact: " + urlContact);

      var name = $("#name").val().trim();
      var email = $("#email").val().trim();
      var phone = $("#phone").val().trim();
      var subject = $("#subject").val().trim();
      var message = $("#message").val().trim();

      // console.log("name: " + name);
      // console.log("email: " + email);
      // console.log("phone: " + phone);
      // console.log("subject: " + subject);
      // console.log("message: " + message);

      if (name && email && phone && subject && message) {
        var emailPattern = /^[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,}$/i;
        var phonePattern = /^[0-9]+$/;

        if (name.length < 3) {
          $("#contact-box").html("Name must be at least 3 characters long.");
        } else if (!phonePattern.test(phone) || phone.length < 6) {
          $("#contact-box").html("Please enter a valid phone number.");
        } else if (!emailPattern.test(email)) {
          $("#contact-box").html("Enter a valid email!");
        } else {
          $.ajax({
            url: urlContact,
            type: "POST",
            dataType: "json",
            contentType: "application/json",
            data: JSON.stringify({
              name: name,
              email: email,
              phone: phone,
              subject: subject,
              message: message,
            }),
            beforeSend: function () {
              $("#contact-box").html("Please wait, sending...");
            },
            success: function (response) {
              console.log(response.success);
              if (response.success) {
                $("#contact-box").html(response.message);
                $("#name, #email, #phone, #subject, #message").val("");
              } else {
                $("#contact-box").html(
                  "Failed to send message: " + response.message
                );
              }
            },
            error: function (xhr, status, error) {
              // console.error("AJAX Error:", xhr.responseText);
              // console.log("error: " + error);
              // console.log("status: " + status);
              $("#contact-box").html(
                "An error occurred. Please try again later."
              );
            },
          });
        }
      } else {
        $("#contact-box").html("Please fill in all fields.");
      }
    });
}

/*-------------------------------------------
        Update Info Form
-------------------------------------------*/

// if (document.getElementById('updateInfo')) {
//     document.getElementById('updateInfo').addEventListener('click', function(event) {
//         event.preventDefault();

//         var first_name = $("#first-name").val().trim();
//         var last_name = $("#last-name").val().trim();
//         var phone = $("#phone").val().trim();
//         var email = $("#email").val().trim();
//         var address = $("#address").val().trim();

//         if (first_name.length <= 3) {
//             $("#msg-box").html("First name must be more than 3 characters.");
//             return false;
//         }
//         if (last_name.length <= 3) {
//             $("#msg-box").html("Last name must be more than 3 characters.");
//             return false;
//         }

//         var phone_pattern = /^[0-9]{7,}$/;
//         if (!phone.match(phone_pattern)) {
//             $("#msg-box").html("Phone number must be at least 7 digits and contain only numbers.");
//             return false;
//         }

//         var email_pattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
//         if (!email.match(email_pattern)) {
//             $("#msg-box").html("Your email is incorrect. Please use the format email@example.com.");
//             return false;
//         }

//         $("#msg-box").html("Please Wait...");

//         $.post(
//             "./profile/update_user.php",
//             {
//                 your_first: first_name,
//                 your_last: last_name,
//                 your_phone: phone,
//                 your_email: email,
//                 your_address: address,
//                 update: "true"
//             },
//             function(data, status) {
//                 $("#msg-box").html(data);
//                 $("#first-name").val("");
//                 $("#last-name").val("");
//                 $("#phone").val("");
//                 $("#email").val("");
//                 $("#address").val("");
//                 window.location.href = "index.php?p=profile";
//             }
//         ).fail(function() {
//             $("#msg-box").html("An error occurred while sending the request.");
//         });
//     });
// }

/*-------------------------------------------
        Forget Form
-------------------------------------------*/

let forget_email;

$(document).ready(function () {
  // Check if forget_email exists in session storage
  if (sessionStorage.getItem("forget_email")) {
    forget_email = sessionStorage.getItem("forget_email");
  }

  let urlForget = path_api + "client/check_email.php";

  $("#passForget").on("submit", function (e) {
    e.preventDefault();
    passForget();
  });

  function passForget() {
    forget_email = $("#email").val().trim();

    // Validate email
    const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if (!emailPattern.test(forget_email)) {
      $("#msg-box").html("Please insert a valid email.");
      return;
    }

    // Store forget_email in session storage
    sessionStorage.setItem("forget_email", forget_email);

    $("#msg-box").html("Please wait...");

    $.ajax({
      url: urlForget,
      type: "POST",
      data: JSON.stringify({ forget_email: forget_email }),
      contentType: "application/json",
      dataType: "json",
      success: function (response) {
        if (response.success) {
          $("#msg-box").html(response.message);
          window.location.href = "index.php?p=reset_password";
        } else {
          $("#msg-box").html(response.message);
        }
      },
      error: function (xhr, status, error) {
        $("#msg-box").html("An error occurred. Please try again later.");
      },
    });
  }

  // -----------------------------------------------//

  let urlCode = path_api + "client/check_reset_code.php";

  $("#resetCode").on("submit", function (e) {
    e.preventDefault();
    resetCode();
  });

  function resetCode() {
    // Check if forget_email is set
    if (!forget_email) {
      $("#msg-box").html(
        "No email found. Please start with the 'Forgot Password' form."
      );
      return;
    }

    let reset_code = $("#reset-code").val().trim();

    // Validate code
    if (!reset_code) {
      $("#msg-box").html("Please insert the reset code sent to your email.");
      return;
    }

    $("#msg-box").html("Please wait...");

    console.log("forget_email: " + forget_email);
    console.log("reset_code: " + reset_code);

    $.ajax({
      url: urlCode,
      type: "POST",
      data: JSON.stringify({
        forget_email: forget_email,
        reset_code: reset_code,
      }),
      contentType: "application/json",
      dataType: "json",
      success: function (response) {
        if (response.success) {
          $("#msg-box").html(response.message);
          window.location.href = "index.php?p=update_password";
        } else {
          $("#msg-box").html(response.message);
        }
      },
      error: function (xhr, status, error) {
        // console.log("xhr: " + xhr);
        // console.log("status: " + status);
        // console.log("error: " + error);
        $("#msg-box").html("An error occurred. Please try again later.");
      },
    });
  }

  // -----------------------------------------------//

  let urlNewPass = path_api + "client/check_new_password.php";

  $("#newPass").on("submit", function (e) {
    e.preventDefault();
    newPass();
  });

  function newPass() {
    // Check if forget_email is set
    if (!forget_email) {
      $("#msg-box").html(
        "No email found. Please start with the 'Forgot Password' form."
      );
      return;
    }

    let new_password = $("#new-password").val().trim();
    let confirm_password = $("#confirm-password").val().trim();

    // Validate password
    if (!new_password || !confirm_password) {
      $("#msg-box").html("Please fill up the form.");
      return;
    }

    if (new_password.length < 6 || confirm_password.length < 6) {
      $("#msg-box").html("Passwords should have more than 6 characters.");
      return;
    }

    if (new_password != confirm_password) {
      $("#msg-box").html("Passwords do not match.");
      return;
    }

    $("#msg-box").html("Please wait...");

    console.log("forget_email: " + forget_email);
    console.log("new_password: " + new_password);
    console.log("confirm_password: " + confirm_password);

    $.ajax({
      url: urlNewPass,
      type: "POST",
      data: JSON.stringify({
        forget_email: forget_email,
        new_password: new_password,
      }),
      contentType: "application/json",
      dataType: "json",
      success: function (response) {
        if (response.success) {
          // Of course remove the email from session
          forget_email = "";
          sessionStorage.removeItem("forget_email");
          $("#msg-box").html(response.message);
          window.location.href = "index.php?p=login";
        } else {
          $("#msg-box").html(response.message);
        }
      },
      error: function (xhr, status, error) {
        // console.log("xhr: " + xhr);
        // console.log("status: " + status);
        // console.log("error: " + error);
        $("#msg-box").html("An error occurred. Please try again later.");
      },
    });
  }
}); //End of document ready for Forget Password Pages
