<!-- ======= Breadcrumb Section ======= -->
<section class="bg-bread">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1 class="" name="cart">Cart</h1>
                <h4 class=""><span name="home">Home</span> / <span name="cart">Cart</span></h4>
            </div>
        </div>
    </div>
</section>
<!-- ====== End Breadcrumb Section ====== -->

<section>
    <div class="container">
        
        <div class="row">
            
            <div class="col-xl-9 col-lg-8 col-md-12">
                <table class="table table-borderless table-striped" id="cartTable">
                    <tr>
                        <th class="rounded-start" name="item">Item</th>
                        <th name="item_name">Item Name</th>
                        <th name="unit_price">Unit Price</th>
                        <th name="qty">Qty</th>
                        <th name="price">Price</th>
                        <th class="rounded-end"></th>
                    </tr>

                    <?php
                    if (isset($_SESSION["cart"]) && count($_SESSION["cart"]) > 0) {
                        foreach ($_SESSION["cart"] as $item_id => $cart_item) {
                    ?>
                            <tr id="cart-item-<?php echo $item_id; ?>">
                                <td class="rounded-start">
                                   <img id="img-<?php echo $item_id; ?>" class="cart-item-img" alt="Product">
                                       
                                   </img> 
                                </td>
                                <td>
                                    <a href="index.php?p=item&item_id=<?php echo $item_id; ?>" id="name-<?php echo $item_id; ?>">
                                        Loading...
                                    </a>
                                </td>
                                <td id="unit-price-<?php echo $item_id; ?>">
                                    Loading...
                                </td>
                                <td>
                                    x<?php echo $cart_item["quantity"]; ?>
                                </td>
                                <td id="price-<?php echo $item_id; ?>">
                                    Loading...
                                </td>
                                <td class="d-flex justify-content-center rounded-end">
                                    <button type="button" class="removeBtn" onclick="update_cart('remove', <?php echo $item_id; ?>)">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 352 512" class="">
                                            <path d="M242.7 256l100.1-100.1c12.3-12.3 12.3-32.2 0-44.5l-22.2-22.2c-12.3-12.3-32.2-12.3-44.5 0L176 189.3 75.9 89.2c-12.3-12.3-32.2-12.3-44.5 0L9.2 111.5c-12.3 12.3-12.3 32.2 0 44.5L109.3 256 9.2 356.1c-12.3 12.3-12.3 32.2 0 44.5l22.2 22.2c12.3 12.3 32.2 12.3 44.5 0L176 322.7l100.1 100.1c12.3 12.3 32.2 12.3 44.5 0l22.2-22.2c12.3-12.3 12.3-32.2 0-44.5L242.7 256z" />
                                        </svg>
                                    </button>
                                </td>
                            </tr>
                    <?php
                        }
                    } else {
                        echo "<tr><td colspan='4' name='no_items'>No items in the cart</td></tr>";
                    }
                    ?>
                </table>

            </div>
                
            <div class="col-xl-3 col-lg-4 col-md-12">
                <table class="table table-borderless table-striped" id="">
                    <tr>
                        <th class="rounded-start" name="total">Total</th>
                        <th class="rounded-end text-end" id="cartTotal">$0</th>
                    </tr>
                </table>
                <div>
                    <?php
                        if (isset($_SESSION['client_id'])) {
                    ?>
                        <div class="d-flex justify-content-between mb-3">
                            <a href="index.php?p=checkout" class="shopBtn" name="checkout">Checkout</a>
                            <button class="shopBtn" onclick="update_cart('empty','')" name="empty_cart">Empty Cart</button>
                        </div>
                    <?php
                        } else {
                    ?>
                        <div class="d-flex justify-content-between mb-3">
                            <a href="index.php?p=checkout" class="shopBtn" name="checkout_guest">Checkout as Guest</a>
                            <a href="index.php?p=login" class="shopBtn" name="login">Login</a>
                        </div>
                        <button class="shopBtn" onclick="update_cart('empty','')" name="empty_cart">Empty Cart</button>
                    <?php
                        }
                    ?>
                </div>
            </div>
                
        </div>

    </div>
</section>

<script>
$(document).ready(function() {
    loadCartItems();
});

// function loadCartItems() {
//     const cart = <?php echo json_encode($_SESSION["cart"]); ?>;
//     const path_api = "<?php echo $path_api; ?>";
//     let total = 0;

//     $.each(cart, function(itemId, cartItem) {
//         const productId = parseInt(itemId);

//         const apiUrl = `${path_api}item.php?id=${productId}`;

//         $.ajax({
//             url: apiUrl,
//             method: 'GET',
//             dataType: 'json',
//             success: function(data) {
//                 if (data.success && data.objects.length > 0) {
//                     const item = data.objects[0];

//                     // Check if there is a discount
//                     let itemPrice = (item.price_discount && item.price_discount > 0) ? item.price_discount : item.price;

//                     const itemTotal = parseFloat(itemPrice) * parseInt(cartItem.quantity);
//                     total += itemTotal;

//                     $(`#img-${productId}`).attr("src", item.image);
//                     $(`#name-${productId}`).text(item.name);
//                     $(`#unit-price-${productId}`).text(`<?php echo $currency; ?>${itemPrice}`);

//                     $(`#cartTotal`).text(`<?php echo $currency; ?>${total.toFixed(2)}`);
//                 } else {
//                     console.error('Item details not found for product ID:', productId);
//                 }
//             },
//             error: function(xhr, status, error) {
//                 console.error('Error fetching item details:', error);
//             }
//         });
//     });
// }

function loadCartItems() {
    const cart = <?php echo json_encode($_SESSION["cart"]); ?>;
    const path_api = "<?php echo $path_api; ?>";

    // Check if cart is not empty before proceeding
    if (cart && Object.keys(cart).length > 0) {
        let total = 0;

        $.each(cart, function(itemId, cartItem) {
            const productId = parseInt(itemId);
            const apiUrl = `${path_api}item.php?id=${productId}`;

            $.ajax({
                url: apiUrl,
                method: 'GET',
                dataType: 'json',
                success: function(data) {
                    if (data.success && data.objects.length > 0) {
                        const item = data.objects[0];

                        // Check if there is a discount
                        let itemPrice = (item.price_discount && item.price_discount > 0) ? item.price_discount : item.price;

                        // Calculate item total based on quantity
                        const itemTotal = parseFloat(itemPrice) * parseInt(cartItem.quantity);
                        total += itemTotal;

                        // Update HTML elements
                        $(`#img-${productId}`).attr("src", item.image[0]);
                        $(`#name-${productId}`).text(item.name);
                        $(`#unit-price-${productId}`).text(`<?php echo $currency; ?>${itemPrice}`);
                        $(`#price-${productId}`).text(`<?php echo $currency; ?>${itemTotal.toFixed(2)}`);

                        // Update the total price in the cart
                        $(`#cartTotal`).text(`<?php echo $currency; ?>${total.toFixed(2)}`);
                    } else {
                        console.error('Item details not found for product ID:', productId);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching item details:', error);
                }
            });
        });
    } else {
        console.log('Cart is empty, no items to load.');
    }
}

</script>
