<!-- ======= Hero Section ======= -->
<section class="bg-bread">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1 class="" name="categories">Categories</h1>
                <h4 class=""> <span name="home">Home</span> / <span name="categories">Categories</span></h4>
            </div>
        </div>
    </div>
</section>
<!-- ====== End Hero Section ====== -->

<!-- Categories Start -->
<section>
    <div class="container">
        <div class="row" id="category-container">
            
        </div>
    </div>
</section>
<!-- Categories End -->

<script>
$(document).ready(function() {
    fetchCategory();
});

function fetchCategory() {
  $.ajax({
    url: '<?php echo $path_api; ?>category.php?language=' + language,
    type: 'GET',
    dataType: 'json',
    success: function(data) {
      if (data.success) {
        const categoryList = $('#category-container');
        let categoryHTML = '';

        $.each(data.objects, function(index, category) {
          categoryHTML += `
            <div class="col-xxl-2 col-xl-3 col-lg-4 col-md-6 d-flex justify-content-center mb-2">
                <div class="product-card position-relative align-items-center">
                    <a class="image-category" href="index.php?p=products&category_id=${category.id}">
                        <img src="${category.image}" alt="${category.name}" class="img-fluid">
                    </a>
                    <div class="pt-3">
                        <h3 class="card-title text-uppercase">
                            <a href="index.php?p=products&category_id=${category.id}">${category.name}</a>
                        </h3>
                    </div>
                </div>
            </div>
            `;
        });
        categoryList.html(categoryHTML);
      }
    },
    error: function(xhr, status, error) {
      console.error('Error fetching products:', error);
    }
  });
}

</script>
